/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.loginsightapi;

import com.vmware.loginsightapi.AuthFailure;
import com.vmware.loginsightapi.Configuration;
import com.vmware.loginsightapi.core.AggregateResponse;
import com.vmware.loginsightapi.core.AuthInfo;
import com.vmware.loginsightapi.core.IngestionRequest;
import com.vmware.loginsightapi.core.IngestionResponse;
import com.vmware.loginsightapi.core.LogInsightApiException;
import com.vmware.loginsightapi.core.LogInsightConnectionStrategy;
import com.vmware.loginsightapi.core.MessageQueryResponse;
import com.vmware.loginsightapi.util.AsyncLogInsightConnectionStrategy;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.message.BasicHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogInsightClient
implements AutoCloseable {
    public static final String DEFAULT_INGESTION_AGENT_ID = "54947df8-0e9e-4471-a2f9-9af509fb5889";
    public static final String API_URL_SESSION_PATH = "/api/v1/sessions";
    public static final String API_URL_INGESTION = "/api/v1/messages/ingest/";
    private String sessionId;
    private LogInsightConnectionStrategy connectionStrategy;
    private Configuration config;
    private final CloseableHttpAsyncClient asyncHttpClient;
    private static final Logger logger = LoggerFactory.getLogger(LogInsightClient.class);

    public LogInsightClient(Configuration config) {
        this.connectionStrategy = new AsyncLogInsightConnectionStrategy();
        this.config = config;
        this.asyncHttpClient = this.connectionStrategy.getHttpClient();
        this.connect();
    }

    public LogInsightClient(Configuration config, LogInsightConnectionStrategy<CloseableHttpAsyncClient> connectionStrategy) {
        this.connectionStrategy = connectionStrategy;
        this.config = config;
        this.asyncHttpClient = connectionStrategy.getHttpClient();
        this.connect();
    }

    public LogInsightClient(String host, String user, String password) {
        this.connectionStrategy = new AsyncLogInsightConnectionStrategy();
        this.config = new Configuration(host, user, password);
        this.asyncHttpClient = this.connectionStrategy.getHttpClient();
        this.connect();
    }

    public LogInsightClient(String host, String user, String password, LogInsightConnectionStrategy<CloseableHttpAsyncClient> connectionStrategy) {
        this.connectionStrategy = connectionStrategy;
        this.config = new Configuration(host, user, password);
        this.asyncHttpClient = connectionStrategy.getHttpClient();
        this.connect();
    }

    public String apiUrl() {
        return this.config.getScheme() + "://" + this.config.getHost() + ":" + this.config.getPort();
    }

    public String sessionUrl() {
        return this.apiUrl() + API_URL_SESSION_PATH;
    }

    public String messageQueryUrl() {
        return this.apiUrl();
    }

    public String messageQueryFullUrl(String url) {
        return this.apiUrl() + url;
    }

    public String aggregateQueryUrl() {
        return this.apiUrl();
    }

    public String aggregateQueryFullUrl(String url) {
        return this.apiUrl() + url;
    }

    public String ingestionApiUrl() {
        return this.config.getScheme() + "://" + this.config.getHost() + ":" + this.config.getIngestionPort() + API_URL_INGESTION + DEFAULT_INGESTION_AGENT_ID;
    }

    public static List<Header> getDefaultHeaders() {
        ArrayList<Header> headers = new ArrayList<Header>();
        headers.add((Header)new BasicHeader("Content-Type", "application/json"));
        headers.add((Header)new BasicHeader("Accept", "application/json"));
        String timestamp = String.valueOf(TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis()));
        headers.add((Header)new BasicHeader("x-li-timestamp", timestamp));
        return headers;
    }

    protected void connect() throws AuthFailure {
        String body = String.format("{\"username\":\"%s\",\"password\":\"%s\"}", this.config.getUser(), this.config.getPassword());
        System.out.println("auth body " + body);
        HttpPost httpPost = new HttpPost(this.sessionUrl());
        httpPost.addHeader("Accept", "application/json");
        httpPost.addHeader("Content-type", "application/json");
        HttpResponse response = null;
        httpPost.setEntity((HttpEntity)new StringEntity(body, ContentType.APPLICATION_JSON));
        try {
            Future future = this.asyncHttpClient.execute((HttpUriRequest)httpPost, null);
            response = (HttpResponse)future.get();
            String serverResponse = IOUtils.toString((InputStream)response.getEntity().getContent(), (String)"UTF-8");
            logger.info("Auth response = " + serverResponse);
            if (response.getStatusLine().getStatusCode() != 200) {
                logger.error("Unable to authenticate. StatusCode=" + response.getStatusLine().getStatusCode());
                logger.error("Unable to authenticate. " + serverResponse);
                throw new AuthFailure("Connection to LogInsight failed. " + serverResponse);
            }
            AuthInfo authInfo = AuthInfo.fromJsonString(serverResponse);
            this.sessionId = authInfo.getSessionId();
        }
        catch (InterruptedException ie) {
            throw new AuthFailure("Connection to LogInsight failed", ie);
        }
        catch (ExecutionException ee) {
            throw new AuthFailure("Connection to LogInsight failed", ee);
        }
        catch (IOException e) {
            throw new AuthFailure("Connection to LogInsight failed", e);
        }
    }

    public void stopAsyncHttpClient() {
        logger.debug("Stopping the AsyncHttpClient");
        try {
            this.asyncHttpClient.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public CompletableFuture<MessageQueryResponse> messageQuery(String apiUrl) {
        HttpGet request = null;
        final CompletableFuture completableFuture = new CompletableFuture();
        try {
            request = this.getHttpRequest(apiUrl, false);
            this.asyncHttpClient.execute((HttpUriRequest)request, (FutureCallback)new FutureCallback<HttpResponse>(){

                public void completed(HttpResponse httpResponse) {
                    try {
                        InputStream responseBody = httpResponse.getEntity().getContent();
                        String responseString = IOUtils.toString((InputStream)responseBody, (String)"UTF-8");
                        logger.warn("Response: " + responseString);
                        completableFuture.complete(MessageQueryResponse.fromJsonString(responseString));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        completableFuture.completeExceptionally(e);
                    }
                }

                public void failed(Exception ex) {
                    completableFuture.completeExceptionally(new LogInsightApiException("Failed message Query", ex));
                }

                public void cancelled() {
                    completableFuture.completeExceptionally(new LogInsightApiException("Cancelled message Query"));
                }
            });
        }
        catch (Exception ie) {
            completableFuture.completeExceptionally(new LogInsightApiException("Message query failed", ie));
        }
        return completableFuture.thenApply(response -> response);
    }

    public CompletableFuture<AggregateResponse> aggregateQuery(String apiUrl) {
        HttpGet request = null;
        final CompletableFuture completableFuture = new CompletableFuture();
        try {
            request = this.getHttpRequest(apiUrl, true);
            logger.debug("Querying " + this.aggregateQueryUrl() + apiUrl);
            this.asyncHttpClient.execute((HttpUriRequest)request, (FutureCallback)new FutureCallback<HttpResponse>(){

                public void completed(HttpResponse httpResponse) {
                    try {
                        String responseString = IOUtils.toString((InputStream)httpResponse.getEntity().getContent(), (String)"UTF-8");
                        logger.warn("Response: " + responseString);
                        completableFuture.complete(AggregateResponse.fromJsonString(responseString));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        completableFuture.completeExceptionally(new LogInsightApiException("Unable to process the query response", e));
                    }
                }

                public void failed(Exception ex) {
                    completableFuture.completeExceptionally(new LogInsightApiException("Failed message Query", ex));
                }

                public void cancelled() {
                    completableFuture.completeExceptionally(new LogInsightApiException("Cancelled message Query"));
                }
            });
        }
        catch (Exception ie) {
            completableFuture.completeExceptionally(new LogInsightApiException("Message query failed", ie));
        }
        return completableFuture.thenApply(response -> response);
    }

    public CompletableFuture<IngestionResponse> ingest(IngestionRequest messages) {
        HttpPost httpPost = null;
        final CompletableFuture completableFuture = new CompletableFuture();
        try {
            httpPost = this.getIngestionHttpRequest(messages);
            logger.info("Sending : " + messages.toJson());
            this.asyncHttpClient.execute((HttpUriRequest)httpPost, (FutureCallback)new FutureCallback<HttpResponse>(){

                public void completed(HttpResponse httpResponse) {
                    try {
                        String responseString = IOUtils.toString((InputStream)httpResponse.getEntity().getContent(), (String)"UTF-8");
                        logger.warn("Response: " + responseString);
                        completableFuture.complete(IngestionResponse.fromJsonString(responseString));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        completableFuture.completeExceptionally(new LogInsightApiException("Unable to process the query response", e));
                    }
                }

                public void failed(Exception ex) {
                    completableFuture.completeExceptionally(new LogInsightApiException("Failed message Query", ex));
                }

                public void cancelled() {
                    completableFuture.completeExceptionally(new LogInsightApiException("Cancelled message Query"));
                }
            });
        }
        catch (Exception e) {
            completableFuture.completeExceptionally(new LogInsightApiException("Ingestion failed", e));
        }
        return completableFuture.thenApply(response -> response);
    }

    public String getSessionId() throws AuthFailure {
        if (this.sessionId == null) {
            throw new AuthFailure("Invalid session id");
        }
        return this.sessionId;
    }

    @Override
    public void close() throws Exception {
        this.stopAsyncHttpClient();
    }

    public List<Header> getSessionHeaders() {
        ArrayList<Header> headers = new ArrayList<Header>();
        headers.add((Header)new BasicHeader("X-li-session-id", this.getSessionId()));
        return headers;
    }

    public void addHeaders(HttpGet request, List<Header> headers) {
        for (Header header : headers) {
            request.addHeader(header);
        }
    }

    public HttpGet getHttpRequest(String apiUrl, boolean isAggregateQuery) {
        HttpGet request = null;
        request = isAggregateQuery ? new HttpGet(this.aggregateQueryUrl() + apiUrl) : new HttpGet(this.messageQueryUrl() + apiUrl);
        this.addHeaders(request, LogInsightClient.getDefaultHeaders());
        this.addHeaders(request, this.getSessionHeaders());
        return request;
    }

    public HttpPost getIngestionHttpRequest(IngestionRequest ingestionRequest) {
        HttpPost httpPost = null;
        httpPost = new HttpPost(this.ingestionApiUrl());
        httpPost.setEntity((HttpEntity)new StringEntity(ingestionRequest.toJson(), ContentType.APPLICATION_JSON));
        httpPost.addHeader("Content-Type", "application/json");
        httpPost.addHeader("Accept", "application/json");
        return httpPost;
    }
}

