/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vipclient.i18n.base;

import com.vmware.vipclient.i18n.base.HttpRequester;
import com.vmware.vipclient.i18n.exceptions.VIPJavaClientException;
import java.net.MalformedURLException;

public class VIPService {
    private static VIPService vIPServiceInstance;
    private HttpRequester httpRequester;
    private String productID;
    private String version;

    private VIPService() {
    }

    public static VIPService getVIPServiceInstance() {
        if (vIPServiceInstance == null) {
            vIPServiceInstance = new VIPService();
        }
        return vIPServiceInstance;
    }

    public void initializeVIPService(String productID, String version, String vIPServer) throws MalformedURLException {
        if (vIPServiceInstance == null) {
            throw new VIPJavaClientException("Please create VIPServiceInstance first!");
        }
        this.productID = productID;
        this.version = version;
        this.createHttpRequester(vIPServer);
    }

    private void createHttpRequester(String vIPServer) throws MalformedURLException {
        if (this.httpRequester == null) {
            this.httpRequester = new HttpRequester(vIPServer);
        }
    }

    public HttpRequester getHttpRequester() {
        if (this.httpRequester == null) {
            throw new VIPJavaClientException("Please create HttpRequester, call createHttpRequest API first! ");
        }
        return this.httpRequester;
    }

    public String getProductID() {
        return this.productID;
    }

    public String getVersion() {
        return this.version;
    }
}

