/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vipclient.i18n.l2.text;

import com.vmware.vipclient.i18n.l2.text.DateFormat;
import com.vmware.vipclient.i18n.l2.text.PatternItem;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.json.simple.JSONObject;

public class SimpleDateFormat
extends DateFormat {
    private String pattern;
    private JSONObject formatData;
    private String locale;
    private static final boolean[] PATTERN_CHAR_IS_SYNTAX = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false};

    public SimpleDateFormat(String pattern, JSONObject formatData, String locale) {
        this.pattern = pattern;
        this.formatData = formatData;
        this.locale = locale;
    }

    @Override
    public String format(Date date, String timeZoneStr) {
        Calendar cal;
        StringBuffer text = new StringBuffer();
        Locale locale1 = Locale.forLanguageTag(this.locale.replace("_", "-"));
        if (!"".equalsIgnoreCase(timeZoneStr)) {
            TimeZone timeZone = TimeZone.getTimeZone(timeZoneStr);
            cal = Calendar.getInstance(timeZone, locale1);
        } else {
            cal = Calendar.getInstance(locale1);
        }
        cal.setTime(date);
        List<Object> items = this.getPatternItems(this.pattern);
        for (Object item : items) {
            if (item instanceof PatternItem) {
                PatternItem patternItem = (PatternItem)item;
                text.append(patternItem.getParser(this.formatData).parse(patternItem, cal));
                continue;
            }
            text.append(item);
        }
        return text.toString();
    }

    public List<Object> getPatternItems(String pattern) {
        boolean isPrevQuote = false;
        boolean inQuote = false;
        StringBuilder text = new StringBuilder();
        char itemType = '\u0000';
        int itemLength = 1;
        ArrayList<Object> items = new ArrayList<Object>();
        for (int i = 0; i < pattern.length(); ++i) {
            char ch = pattern.charAt(i);
            if (ch == '\'') {
                if (isPrevQuote) {
                    text.append('\'');
                    isPrevQuote = false;
                } else {
                    isPrevQuote = true;
                    if (itemType != '\u0000') {
                        items.add(new PatternItem(itemType, itemLength));
                        itemType = '\u0000';
                    }
                }
                inQuote = !inQuote;
                continue;
            }
            isPrevQuote = false;
            if (inQuote) {
                text.append(ch);
                continue;
            }
            if (SimpleDateFormat.isSyntaxChar(ch)) {
                if (ch == itemType) {
                    ++itemLength;
                    continue;
                }
                if (itemType == '\u0000') {
                    if (text.length() > 0) {
                        items.add(text.toString());
                        text.setLength(0);
                    }
                } else {
                    items.add(new PatternItem(itemType, itemLength));
                }
                itemType = ch;
                itemLength = 1;
                continue;
            }
            if (itemType != '\u0000') {
                items.add(new PatternItem(itemType, itemLength));
                itemType = '\u0000';
            }
            text.append(ch);
        }
        if (itemType == '\u0000') {
            if (text.length() > 0) {
                items.add(text.toString());
                text.setLength(0);
            }
        } else {
            items.add(new PatternItem(itemType, itemLength));
        }
        return items;
    }

    private static boolean isSyntaxChar(char ch) {
        return ch < PATTERN_CHAR_IS_SYNTAX.length ? PATTERN_CHAR_IS_SYNTAX[ch & 0xFF] : false;
    }
}

