/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vipclient.i18n;

import com.vmware.vipclient.i18n.base.DataSourceEnum;
import com.vmware.vipclient.i18n.base.Task;
import com.vmware.vipclient.i18n.base.VIPService;
import com.vmware.vipclient.i18n.base.cache.Cache;
import com.vmware.vipclient.i18n.base.cache.CacheMode;
import com.vmware.vipclient.i18n.base.cache.TranslationCacheManager;
import com.vmware.vipclient.i18n.exceptions.VIPClientInitException;
import com.vmware.vipclient.i18n.messages.dto.MessagesDTO;
import com.vmware.vipclient.i18n.messages.service.ProductService;
import com.vmware.vipclient.i18n.util.LocaleUtility;
import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VIPCfg {
    Logger logger = LoggerFactory.getLogger(VIPCfg.class);
    private static VIPCfg gcInstance;
    private static Map<String, VIPCfg> moduleCfgs;
    private VIPService vipService;
    private TranslationCacheManager translationCacheManager;
    @Deprecated
    private DataSourceEnum messageOrigin = DataSourceEnum.VIP;
    private List<DataSourceEnum> msgOriginsQueue = new LinkedList<DataSourceEnum>();
    private CacheMode cacheMode = CacheMode.MEMORY;
    private String cachePath;
    private boolean pseudo;
    private boolean collectSource;
    private boolean cleanCache;
    private long cacheExpiredTime;
    private boolean machineTranslation;
    private boolean initializeCache;
    private int interalCleanCache;
    private String productName;
    private String version;
    private String vipServer;
    private String i18nScope = "numbers,dates,currencies,plurals,measurements";
    private String offlineResourcesBaseUrl;
    public static final String CACHE_L3 = "CACHE_L3";
    public static final String CACHE_L2 = "CACHE_L2";
    private boolean isSubInstance = false;

    public boolean isSubInstance() {
        return this.isSubInstance;
    }

    public void setSubInstance(boolean subInstance) {
        this.isSubInstance = subInstance;
    }

    private VIPCfg() {
    }

    public static synchronized VIPCfg getInstance() {
        if (gcInstance == null) {
            gcInstance = new VIPCfg();
        }
        return gcInstance;
    }

    public static synchronized VIPCfg getSubInstance(String productName) {
        if (!moduleCfgs.containsKey(productName)) {
            VIPCfg cfg = new VIPCfg();
            cfg.isSubInstance = true;
            moduleCfgs.put(productName, cfg);
        }
        if (moduleCfgs.containsKey(productName) && moduleCfgs.get(productName) != null) {
            return moduleCfgs.get(productName);
        }
        return gcInstance;
    }

    public void initialize(String vipServer, String productName, String version) {
        this.productName = productName;
        this.version = version;
        this.vipServer = vipServer;
    }

    public void initialize(String cfg) throws VIPClientInitException {
        ResourceBundle prop = ResourceBundle.getBundle(cfg);
        if (prop == null) {
            throw new VIPClientInitException("Can't not initialize VIPCfg, resource bundle is null.");
        }
        if (prop.containsKey("productName")) {
            this.productName = prop.getString("productName");
        }
        if (this.isSubInstance() && !moduleCfgs.containsKey(this.productName)) {
            throw new VIPClientInitException("Can't not initialize sub VIPCfg instance, the product name is not defined in config file.");
        }
        if (prop.containsKey("version")) {
            this.version = prop.getString("version");
        }
        this.setMsgOriginsQueue(new LinkedList<DataSourceEnum>());
        if (prop.containsKey("vipServer")) {
            this.vipServer = prop.getString("vipServer");
            this.addMsgOriginsQueue(DataSourceEnum.VIP);
        }
        if (prop.containsKey("offlineResourcesBaseUrl")) {
            this.offlineResourcesBaseUrl = prop.getString("offlineResourcesBaseUrl");
            this.addMsgOriginsQueue(DataSourceEnum.Bundle);
        }
        if (prop.containsKey("pseudo")) {
            this.pseudo = Boolean.parseBoolean(prop.getString("pseudo"));
        }
        if (prop.containsKey("collectSource")) {
            this.collectSource = Boolean.parseBoolean(prop.getString("collectSource"));
        }
        if (prop.containsKey("initializeCache")) {
            this.initializeCache = Boolean.parseBoolean(prop.getString("initializeCache"));
        }
        if (prop.containsKey("cleanCache")) {
            this.cleanCache = Boolean.parseBoolean(prop.getString("cleanCache"));
        }
        if (prop.containsKey("machineTranslation")) {
            this.machineTranslation = Boolean.parseBoolean(prop.getString("machineTranslation"));
        }
        if (prop.containsKey("i18nScope")) {
            this.i18nScope = prop.getString("i18nScope");
        }
        if (prop.containsKey("cacheExpiredTime")) {
            this.cacheExpiredTime = Long.parseLong(prop.getString("cacheExpiredTime"));
        }
        if (prop.containsKey("defaultLocale")) {
            LocaleUtility.setDefaultLocale(Locale.forLanguageTag(prop.getString("defaultLocale")));
            LocaleUtility.setFallbackLocales(new LinkedList<Locale>(Arrays.asList(LocaleUtility.getDefaultLocale(), Locale.forLanguageTag("source"))));
        }
        if (prop.containsKey("sourceLocale")) {
            LocaleUtility.setSourceLocale(Locale.forLanguageTag(prop.getString("sourceLocale")));
        }
    }

    public void initializeVIPService() {
        this.vipService = VIPService.getVIPServiceInstance();
        try {
            this.vipService.initializeVIPService(this.productName, this.version, this.vipServer);
        }
        catch (MalformedURLException e) {
            this.logger.error("'vipServer' " + this.vipServer + " in configuration isn't a valid URL!");
        }
    }

    public void setTranslationCache(Cache c) {
        Cache createdCache;
        this.translationCacheManager = TranslationCacheManager.createTranslationCacheManager();
        if (this.translationCacheManager != null) {
            this.translationCacheManager.registerCache(CACHE_L3, c);
            this.logger.info("Translation Cache created.");
        }
        if (this.isInitializeCache()) {
            this.logger.info("Initializing Cache.");
            this.initializeMessageCache();
        }
        if (this.isCleanCache()) {
            this.logger.info("startTaskOfCacheClean.");
            Task.startTaskOfCacheClean(VIPCfg.getInstance(), this.interalCleanCache);
        }
        if ((createdCache = TranslationCacheManager.getCache(CACHE_L3)) != null && this.getCacheExpiredTime() != 0L) {
            c.setExpiredTime(this.getCacheExpiredTime());
        }
    }

    public synchronized Cache createTranslationCache(Class cacheClass) {
        this.translationCacheManager = TranslationCacheManager.createTranslationCacheManager();
        if (this.translationCacheManager != null) {
            if (TranslationCacheManager.getCache(CACHE_L3) == null) {
                Cache c;
                this.translationCacheManager.registerCache(CACHE_L3, cacheClass);
                this.logger.info("Translation Cache created.");
                if (this.isInitializeCache()) {
                    this.logger.info("InitializeCache.");
                    this.initializeMessageCache();
                }
                if (this.isCleanCache()) {
                    this.logger.info("startTaskOfCacheClean.");
                    Task.startTaskOfCacheClean(VIPCfg.getInstance(), this.interalCleanCache);
                }
                if ((c = TranslationCacheManager.getCache(CACHE_L3)) != null && this.getCacheExpiredTime() != 0L) {
                    c.setExpiredTime(this.getCacheExpiredTime());
                }
            }
            return TranslationCacheManager.getCache(CACHE_L3);
        }
        return null;
    }

    public Cache createFormattingCache(Class cacheClass) {
        this.translationCacheManager = TranslationCacheManager.createTranslationCacheManager();
        if (this.translationCacheManager != null) {
            this.translationCacheManager.registerCache(CACHE_L2, cacheClass);
            this.logger.info("Formatting cache created.");
        }
        if (this.isCleanCache()) {
            this.logger.error("clean cache.");
            Task.startTaskOfCacheClean(VIPCfg.getInstance(), this.interalCleanCache);
        }
        return TranslationCacheManager.getCache(CACHE_L2);
    }

    public void initializeMessageCache() {
        MessagesDTO dto = new MessagesDTO();
        dto.setProductID(this.getProductName());
        dto.setVersion(this.getVersion());
        new ProductService(dto).getAllComponentTranslation();
        if (this.translationCacheManager != null) {
            this.logger.info("Translation data is loaded to cache, size is " + this.translationCacheManager.size() + ".");
        }
    }

    public String getProductName() {
        return this.productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getVipServer() {
        return this.vipServer;
    }

    public void setVipServer(String vipServer) {
        this.vipServer = vipServer;
    }

    public boolean isPseudo() {
        return this.pseudo;
    }

    public void setPseudo(boolean pseudo) {
        this.pseudo = pseudo;
    }

    public boolean isCollectSource() {
        return this.collectSource;
    }

    public void setCollectSource(boolean collectSource) {
        this.collectSource = collectSource;
    }

    public boolean isCleanCache() {
        return this.cleanCache;
    }

    public void setCleanCache(boolean cleanCache) {
        this.cleanCache = cleanCache;
    }

    public VIPService getVipService() {
        return this.vipService;
    }

    public TranslationCacheManager getCacheManager() {
        return this.translationCacheManager;
    }

    public int getInteralCleanCache() {
        return this.interalCleanCache;
    }

    public void setInteralCleanCache(int interalCleanCache) {
        this.interalCleanCache = interalCleanCache;
    }

    public String getI18nScope() {
        return this.i18nScope;
    }

    public void setI18nScope(String i18nScope) {
        this.i18nScope = i18nScope;
    }

    public boolean isMachineTranslation() {
        return this.machineTranslation;
    }

    public void setMachineTranslation(boolean machineTranslation) {
        this.machineTranslation = machineTranslation;
    }

    @Deprecated
    public DataSourceEnum getMessageOrigin() {
        return this.messageOrigin;
    }

    @Deprecated
    public void setMessageOrigin(DataSourceEnum messageOrigin) {
        this.messageOrigin = messageOrigin;
    }

    public boolean isInitializeCache() {
        return this.initializeCache;
    }

    public void setInitializeCache(boolean initializeCache) {
        this.initializeCache = initializeCache;
    }

    @Deprecated
    public long getCacheExpiredTime() {
        return this.cacheExpiredTime;
    }

    @Deprecated
    public void setCacheExpiredTime(long cacheExpiredTime) {
        this.cacheExpiredTime = cacheExpiredTime;
    }

    public CacheMode getCacheMode() {
        return this.cacheMode;
    }

    public void setCacheMode(CacheMode cacheMode) {
        this.cacheMode = cacheMode;
    }

    public String getCachePath() {
        return this.cachePath;
    }

    public void setCachePath(String cachePath) {
        this.cachePath = cachePath;
    }

    public String getOfflineResourcesBaseUrl() {
        return this.offlineResourcesBaseUrl;
    }

    public void setOfflineResourcesBaseUrl(String offlineResourcesBaseUrl) {
        this.offlineResourcesBaseUrl = offlineResourcesBaseUrl;
    }

    public List<DataSourceEnum> getMsgOriginsQueue() {
        return this.msgOriginsQueue;
    }

    public void addMsgOriginsQueue(DataSourceEnum dataSource) {
        this.msgOriginsQueue.add(dataSource);
    }

    public void setMsgOriginsQueue(List<DataSourceEnum> msgOriginsQueue) {
        this.msgOriginsQueue = msgOriginsQueue;
    }

    static {
        moduleCfgs = new HashMap<String, VIPCfg>();
    }
}

