/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vipclient.i18n.base.instances;

import com.vmware.vipclient.i18n.VIPCfg;
import com.vmware.vipclient.i18n.base.cache.MessageCacheItem;
import com.vmware.vipclient.i18n.base.instances.Message;
import com.vmware.vipclient.i18n.exceptions.VIPJavaClientException;
import com.vmware.vipclient.i18n.messages.dto.MessagesDTO;
import com.vmware.vipclient.i18n.messages.service.ComponentService;
import com.vmware.vipclient.i18n.messages.service.ComponentsService;
import com.vmware.vipclient.i18n.messages.service.StringService;
import com.vmware.vipclient.i18n.util.FormatUtils;
import com.vmware.vipclient.i18n.util.JSONUtils;
import com.vmware.vipclient.i18n.util.LocaleUtility;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.json.simple.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TranslationMessage
implements Message {
    Logger logger = LoggerFactory.getLogger(TranslationMessage.class);
    private VIPCfg cfg;

    public VIPCfg getCfg() {
        return this.cfg;
    }

    public void setCfg(VIPCfg cfg) {
        this.cfg = cfg;
    }

    public String getMessage(Locale locale, String component, String key, Object ... args) {
        String source = this.getMessages(Locale.forLanguageTag("source"), component).get(key);
        String collectedSourceMsg = this.getMessages(LocaleUtility.getSourceLocale(), component).get(key);
        if (source != null && !source.isEmpty() && !source.equals(collectedSourceMsg)) {
            return FormatUtils.format(source, LocaleUtility.getSourceLocale(), args);
        }
        String message = FormatUtils.format(this.getMessages(locale, component).get(key), locale, args);
        if (message == null || message.isEmpty()) {
            throw new VIPJavaClientException(FormatUtils.format("Failed to get any message for key: {0} of component {1}, requested locale: {2}", key, component, locale));
        }
        return message;
    }

    public String getString(Locale locale, String component, String key, String source, String comment, Object ... args) {
        this.logger.trace("Start to execute TranslationMessage.getString");
        if (key == null || key.equalsIgnoreCase("")) {
            return "";
        }
        String translation = "";
        StringService s = new StringService();
        if (!LocaleUtility.isDefaultLocale(locale)) {
            MessagesDTO remoteEnDTO;
            String remoteEnMsg;
            MessagesDTO dto = new MessagesDTO(component, key, source, locale.toLanguageTag(), this.cfg);
            translation = s.getString(dto);
            if (!(source == null || "".equals(source) || VIPCfg.getInstance().isPseudo() || source.equals(remoteEnMsg = s.getString(remoteEnDTO = new MessagesDTO(component, key, source, LocaleUtility.getDefaultLocale().toLanguageTag(), this.cfg))))) {
                translation = source;
            }
            if (translation == null || translation.isEmpty()) {
                translation = source;
            }
        } else {
            translation = source;
        }
        if (VIPCfg.getInstance().isCollectSource() || VIPCfg.getInstance().isMachineTranslation()) {
            MessagesDTO latestSourceDTO = new MessagesDTO(component, key, source, "latest", this.cfg);
            String latestStr = s.getString(latestSourceDTO);
            if (source != null && !source.equals(latestStr)) {
                MessagesDTO dto2 = new MessagesDTO(component, key, source, locale.toLanguageTag(), this.cfg);
                String mt = s.postString(dto2);
                if (VIPCfg.getInstance().isMachineTranslation() && !"".equalsIgnoreCase(mt)) {
                    translation = mt;
                }
            }
        }
        if (!VIPCfg.getInstance().isMachineTranslation() && VIPCfg.getInstance().isPseudo() && null != translation && translation.equals(source)) {
            translation = "@@" + translation + "@@";
        }
        if (args != null && args.length > 0) {
            translation = null != translation && translation.equals(source) || VIPCfg.getInstance().isPseudo() ? FormatUtils.formatMsg(translation, LocaleUtility.getDefaultLocale(), args) : FormatUtils.formatMsg(translation, locale, args);
        }
        return translation;
    }

    public boolean postStrings(Locale locale, String component, List<JSONObject> sources) {
        this.logger.trace("Start to execute TranslationMessage.postStrings");
        if (sources == null || sources.isEmpty()) {
            return false;
        }
        MessagesDTO dto = new MessagesDTO();
        dto.setLocale(locale.toLanguageTag());
        dto.setComponent(component);
        if (this.cfg != null) {
            dto.setProductID(this.cfg.getProductName());
            dto.setVersion(this.cfg.getVersion());
        }
        ArrayList<JSONObject> sourcesList = new ArrayList<JSONObject>();
        sourcesList.addAll(sources);
        ArrayList<JSONObject> removedList = new ArrayList<JSONObject>();
        for (JSONObject jo : sourcesList) {
            String key = (String)jo.get((Object)"key");
            String source = (String)jo.get((Object)"source");
            dto.setKey(key);
            dto.setSource(source);
            dto.setLocale("latest");
            String enStr = new StringService().getString(dto);
            if (source == null || !source.equals(enStr)) continue;
            removedList.add(jo);
        }
        sourcesList.removeAll(removedList);
        if (sourcesList.isEmpty()) {
            return true;
        }
        dto.setLocale(locale.toLanguageTag());
        return new StringService().postStrings(sourcesList, dto);
    }

    public boolean postString(Locale locale, String component, String key, String source, String comment) {
        this.logger.trace("Start to execute TranslationMessage.postString");
        MessagesDTO dto = new MessagesDTO();
        dto.setComponent(component);
        dto.setComment(comment);
        dto.setKey(key);
        dto.setSource(source);
        StringService s = new StringService();
        dto.setLocale("latest");
        if (this.cfg != null) {
            dto.setProductID(this.cfg.getProductName());
            dto.setVersion(this.cfg.getVersion());
        }
        String enStr = s.getString(dto);
        if (source != null && !"".equalsIgnoreCase(source) && !source.equals(enStr)) {
            dto.setLocale(locale.toLanguageTag());
            String recievedStr = s.postString(dto);
            return !JSONUtils.isEmpty(recievedStr);
        }
        return true;
    }

    @Deprecated
    public Map<String, String> getStrings(Locale locale, String component) {
        this.logger.trace("Start to execute TranslationMessage.getStrings");
        MessagesDTO dto = new MessagesDTO();
        dto.setLocale(locale.toLanguageTag());
        dto.setComponent(component);
        if (this.cfg != null) {
            dto.setProductID(this.cfg.getProductName());
            dto.setVersion(this.cfg.getVersion());
        }
        ComponentService cs = new ComponentService(dto);
        return cs.getMessages().getCachedData();
    }

    public Map<String, String> getMessages(Locale locale, String component) {
        MessagesDTO dto = new MessagesDTO(component, null, null, locale.toLanguageTag(), this.cfg);
        MessageCacheItem cacheItem = new ComponentService(dto).getMessages();
        return cacheItem.getCachedData();
    }

    public Map<Locale, Map<String, Map<String, String>>> getStrings(Set<Locale> locales, Set<String> components) {
        this.logger.trace("Start to execute TranslationMessage.getStrings of multiple components of multiple locales.");
        Map<Locale, Map<String, Map<String, String>>> retMap = new HashMap<Locale, Map<String, Map<String, String>>>();
        if (null == locales || locales.isEmpty() || null == components || components.isEmpty()) {
            this.logger.error("Wrong parameter(s)! locales: {}, components: {}.", locales, components);
            return retMap;
        }
        try {
            VIPCfg config = this.cfg;
            if (null == config) {
                config = VIPCfg.getInstance();
            }
            ComponentsService cs = new ComponentsService(config);
            retMap = cs.getTranslation(components, locales);
        }
        catch (Exception e) {
            this.logger.error("An exception occured! ", (Throwable)e);
        }
        return retMap;
    }

    public String getString2(String component, String bundle, Locale locale, String key, Object ... args) {
        String source;
        this.logger.trace("Start to execute TranslationMessage.getString2");
        if (key == null || key.equalsIgnoreCase("")) {
            return "";
        }
        String message = "";
        try {
            ResourceBundle rb = ResourceBundle.getBundle(bundle, LocaleUtility.getDefaultLocale());
            source = rb.getString(key);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
            source = key;
        }
        message = this.getString(locale, component, key, source, "", args);
        return message;
    }

    public boolean isAvailable(String component, Locale locale) {
        this.logger.trace("Start to execute component-based TranslationMessage.isAvailable");
        boolean available = false;
        if (!LocaleUtility.isDefaultLocale(locale)) {
            MessagesDTO dto = new MessagesDTO();
            dto.setComponent(component);
            dto.setLocale(locale.toLanguageTag());
            if (this.cfg != null) {
                dto.setProductID(this.cfg.getProductName());
                dto.setVersion(this.cfg.getVersion());
            }
            ComponentService cs = new ComponentService(dto);
            available = cs.isComponentAvailable();
        }
        return available;
    }

    public boolean isAvailable(String component, String key, Locale locale) {
        this.logger.trace("Start to execute string-based TranslationMessage.isAvailable");
        boolean available = false;
        if (!LocaleUtility.isDefaultLocale(locale)) {
            MessagesDTO dto = new MessagesDTO();
            dto.setComponent(component);
            dto.setKey(key);
            dto.setLocale(locale.toLanguageTag());
            if (this.cfg != null) {
                dto.setProductID(this.cfg.getProductName());
                dto.setVersion(this.cfg.getVersion());
            }
            available = new StringService().isStringAvailable(dto);
        }
        return available;
    }
}

