/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vipclient.i18n.messages.api.opt.server;

import com.vmware.vipclient.i18n.VIPCfg;
import com.vmware.vipclient.i18n.base.cache.MessageCacheItem;
import com.vmware.vipclient.i18n.exceptions.VIPJavaClientException;
import com.vmware.vipclient.i18n.messages.api.opt.BaseOpt;
import com.vmware.vipclient.i18n.messages.api.opt.Opt;
import com.vmware.vipclient.i18n.messages.api.url.URLUtils;
import com.vmware.vipclient.i18n.messages.api.url.V2URL;
import com.vmware.vipclient.i18n.util.StringUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.json.simple.JSONObject;
import org.json.simple.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentsBasedOpt
extends BaseOpt
implements Opt {
    private final Logger logger = LoggerFactory.getLogger((String)ComponentsBasedOpt.class.getName());
    private final VIPCfg cfg;

    public ComponentsBasedOpt(VIPCfg cfg) {
        this.cfg = cfg;
    }

    public JSONObject queryFromServer(Set<String> components, Set<String> locales, MessageCacheItem cacheItem) {
        String url = V2URL.getComponentsTranslationURL(VIPCfg.getInstance().getVipService().getHttpRequester().getBaseURL(), this.cfg);
        HashMap<String, String> requestData = new HashMap<String, String>();
        requestData.put("locales", String.join((CharSequence)",", locales));
        requestData.put("components", String.join((CharSequence)",", components));
        Map<String, Object> response = VIPCfg.getInstance().getVipService().getHttpRequester().request(url, "GET", requestData);
        this.responseStr = (String)response.get("body");
        String etag = URLUtils.createEtagString((Map)response.get("headers"));
        long timestamp = (Long)response.get("response_timestamp");
        Long maxAgeMillis = (Long)response.get("max-age");
        cacheItem.setCacheItem(null, etag, timestamp, maxAgeMillis);
        if (StringUtil.isEmpty(this.responseStr)) {
            throw new VIPJavaClientException("Server returned empty.");
        }
        try {
            this.parseServerResponse();
        }
        catch (ParseException e) {
            throw new VIPJavaClientException("The content from server is wrong!", e);
        }
        int statusCode = this.getResponseCode(this.responseJsonObj);
        if (!this.isSuccess(statusCode)) {
            throw new VIPJavaClientException(String.format("Server returned error! Status: %d. Message: %s", statusCode, this.getResponseMessage(this.responseJsonObj)));
        }
        return this.responseJsonObj;
    }
}

