/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vipclient.i18n.messages.api.opt.server;

import com.vmware.vipclient.i18n.VIPCfg;
import com.vmware.vipclient.i18n.base.HttpRequester;
import com.vmware.vipclient.i18n.messages.api.opt.PatternOpt;
import com.vmware.vipclient.i18n.messages.api.url.V2URL;
import java.util.Map;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.json.simple.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemotePatternOpt
implements PatternOpt {
    Logger logger = LoggerFactory.getLogger(RemotePatternOpt.class);

    @Override
    public JSONObject getPatterns(String locale) {
        this.logger.debug("Look for pattern from Singleton Service for locale [{}]!", (Object)locale);
        String responseStr = "";
        String i18nScope = VIPCfg.getInstance().getI18nScope();
        HttpRequester httpRequester = VIPCfg.getInstance().getVipService().getHttpRequester();
        if (i18nScope != null && !"".equalsIgnoreCase(i18nScope)) {
            Map<String, Object> response = httpRequester.request(V2URL.getPatternURL(locale, httpRequester.getBaseURL()), "GET", null);
            responseStr = (String)response.get("body");
        }
        if (null == responseStr || responseStr.equals("")) {
            return null;
        }
        Object dataObj = this.getCategoriesFromResponse(responseStr, "categories");
        JSONObject msgObject = null;
        if (dataObj != null) {
            msgObject = (JSONObject)dataObj;
        }
        return msgObject;
    }

    @Override
    public JSONObject getPatterns(String language, String region) {
        this.logger.debug("Look for pattern from Singleton Service for language [{}], region [{}]!", (Object)language, (Object)region);
        String responseStr = "";
        String i18nScope = VIPCfg.getInstance().getI18nScope();
        HttpRequester httpRequester = VIPCfg.getInstance().getVipService().getHttpRequester();
        if (i18nScope != null && !"".equalsIgnoreCase(i18nScope)) {
            Map<String, Object> response = httpRequester.request(V2URL.getPatternURL(language, region, httpRequester.getBaseURL()), "GET", null);
            responseStr = (String)response.get("body");
        }
        if (null == responseStr || responseStr.equals("")) {
            return null;
        }
        Object dataObj = this.getCategoriesFromResponse(responseStr, "categories");
        JSONObject msgObject = null;
        if (dataObj != null) {
            msgObject = (JSONObject)dataObj;
        }
        return msgObject;
    }

    private Object getCategoriesFromResponse(String responseStr, String node) {
        Object msgObject = null;
        try {
            Object dataObj;
            JSONObject responseObj = (JSONObject)JSONValue.parseWithException((String)responseStr);
            if (responseObj != null && (dataObj = responseObj.get((Object)"data")) != null && dataObj instanceof JSONObject) {
                msgObject = ((JSONObject)dataObj).get((Object)node);
            }
        }
        catch (ParseException e) {
            this.logger.error(e.getMessage());
        }
        return msgObject;
    }
}

