/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vipclient.i18n.messages.service;

import com.vmware.vipclient.i18n.VIPCfg;
import com.vmware.vipclient.i18n.base.DataSourceEnum;
import com.vmware.vipclient.i18n.messages.dto.LocaleDTO;
import com.vmware.vipclient.i18n.messages.service.FormattingCacheService;
import com.vmware.vipclient.i18n.util.LocaleUtility;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocaleService {
    Logger logger = LoggerFactory.getLogger((String)LocaleService.class.getName());
    private LocaleDTO dto = null;

    public LocaleService() {
    }

    public LocaleService(LocaleDTO dto) {
        this.dto = dto;
    }

    public Map<String, String> getRegions(String locale) {
        Map<String, String> regionMap = this.getRegionsByLocale(locale);
        if (regionMap != null) {
            return regionMap;
        }
        Iterator<Locale> fallbackLocalesIter = LocaleUtility.getFallbackLocales().iterator();
        while (fallbackLocalesIter.hasNext()) {
            String fallbackLocale = fallbackLocalesIter.next().toLanguageTag();
            if (fallbackLocale.equalsIgnoreCase(locale)) continue;
            this.logger.info("Can't find regions for locale [{}], look for fallback locale [{}] regions as fallback!", (Object)locale, (Object)fallbackLocale);
            regionMap = this.getRegionsByLocale(fallbackLocale);
            if (regionMap == null) continue;
            new FormattingCacheService().addRegions(locale, regionMap);
            this.logger.debug("Fallback locale [{}] regions is cached for locale [{}]!\n\n", (Object)fallbackLocale, (Object)locale);
            break;
        }
        return regionMap;
    }

    public Map<String, String> getRegionsByLocale(String locale) {
        if (locale != null && !locale.isEmpty()) {
            locale = locale.replace("_", "-").toLowerCase();
        }
        Map<String, String> regionMap = null;
        this.logger.debug("Look for region list from cache for locale [{}]", (Object)locale);
        FormattingCacheService formattingCacheService = new FormattingCacheService();
        regionMap = formattingCacheService.getRegions(locale);
        if (regionMap != null) {
            this.logger.debug("Find regions from cache for locale [{}]!", (Object)locale);
            return regionMap;
        }
        regionMap = this.getRegionsFromDS(locale, VIPCfg.getInstance().getMsgOriginsQueue().listIterator());
        if (regionMap != null) {
            this.logger.debug("Find the regions for locale [{}].\n", (Object)locale);
            formattingCacheService.addRegions(locale, regionMap);
            this.logger.debug("Regions is cached for locale [{}]!\n\n", (Object)locale);
            return regionMap;
        }
        return regionMap;
    }

    private Map<String, String> getRegionsFromDS(String locale, ListIterator<DataSourceEnum> msgSourceQueueIter) {
        Map<String, String> regions = null;
        if (!msgSourceQueueIter.hasNext()) {
            this.logger.error("Failed to get regions from any data source");
            return regions;
        }
        DataSourceEnum dataSource = msgSourceQueueIter.next();
        regions = dataSource.createLocaleOpt(this.dto).getRegions(locale);
        if (regions == null || regions.isEmpty()) {
            this.logger.debug("Failed to get regions from {0} data source", (Object)dataSource.toString());
            regions = this.getRegionsFromDS(locale, msgSourceQueueIter);
        }
        return regions;
    }

    public Map<String, String> getDisplayNames(String locale) {
        Map<Object, Object> dispMap = new HashMap();
        dispMap = this.getSupportedDisplayNamesByLocale(locale);
        if (dispMap != null && !dispMap.isEmpty()) {
            return dispMap;
        }
        Iterator<Locale> fallbackLocalesIter = LocaleUtility.getFallbackLocales().iterator();
        while (fallbackLocalesIter.hasNext()) {
            String fallbackLocale = fallbackLocalesIter.next().toLanguageTag();
            if (fallbackLocale.equalsIgnoreCase(locale)) continue;
            this.logger.info("Can't find supported languages for locale [{}], look for fallback locale [{}] languages as fallback!", (Object)locale, (Object)fallbackLocale);
            dispMap = this.getSupportedDisplayNamesByLocale(fallbackLocale);
            if (dispMap == null || dispMap.size() <= 0) continue;
            new FormattingCacheService().addSupportedLanguages(this.dto, locale, dispMap);
            this.logger.debug("Fallback locale [{}] displayNames is cached for product [{}], version [{}], locale [{}]!\n\n", new Object[]{fallbackLocale, this.dto.getProductID(), this.dto.getVersion(), locale});
            break;
        }
        return dispMap;
    }

    public Map<String, String> getSupportedDisplayNamesByLocale(String locale) {
        if (locale != null && !locale.isEmpty()) {
            locale = locale.replace("_", "-").toLowerCase();
        }
        Map<Object, Object> dispMap = new HashMap();
        this.logger.debug("Look for displayNames from cache for locale [{}]", (Object)locale);
        FormattingCacheService formattingCacheService = new FormattingCacheService();
        dispMap = formattingCacheService.getSupportedLanguages(this.dto, locale);
        if (dispMap != null) {
            this.logger.debug("Find displayNames from cache for product [{}], version [{}], locale [{}]!", new Object[]{this.dto.getProductID(), this.dto.getVersion(), locale});
            return dispMap;
        }
        dispMap = this.getSupportedLanguagesFromDS(locale, VIPCfg.getInstance().getMsgOriginsQueue().listIterator());
        if (dispMap != null && dispMap.size() > 0) {
            this.logger.debug("Find the displayNames for product [{}], version [{}], locale [{}].\n", new Object[]{this.dto.getProductID(), this.dto.getVersion(), locale});
            formattingCacheService.addSupportedLanguages(this.dto, locale, dispMap);
            this.logger.debug("DisplayNames is cached for product [{}], version [{}], locale [{}]!\n\n", new Object[]{this.dto.getProductID(), this.dto.getVersion(), locale});
            return dispMap;
        }
        return dispMap;
    }

    private Map<String, String> getSupportedLanguagesFromDS(String locale, ListIterator<DataSourceEnum> msgSourceQueueIter) {
        Map<String, String> dispMap = new HashMap<String, String>();
        if (!msgSourceQueueIter.hasNext()) {
            this.logger.error("Failed to get supported languages from any data source");
            return dispMap;
        }
        DataSourceEnum dataSource = msgSourceQueueIter.next();
        dispMap = dataSource.createLocaleOpt(this.dto).getSupportedLanguages(locale);
        if (dispMap == null || dispMap.isEmpty()) {
            this.logger.debug("Failed to get supported languages from {0} data source", (Object)dataSource.toString());
            dispMap = this.getSupportedLanguagesFromDS(locale, msgSourceQueueIter);
        }
        return dispMap;
    }
}

