/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vipclient.i18n.filters;

import com.vmware.vipclient.i18n.messages.service.PatternService;
import com.vmware.vipclient.i18n.util.LocaleUtility;
import java.io.IOException;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.json.simple.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VIPPatternFilter
implements Filter {
    Logger logger = LoggerFactory.getLogger(VIPPatternFilter.class);

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String locale = this.getParamFromQuery(request, "locale");
        JSONObject ctmap = null;
        String messages = "{}";
        if (!LocaleUtility.isDefaultLocale(locale) && (ctmap = new PatternService().getPatterns(locale)) != null) {
            messages = JSONObject.toJSONString((Map)ctmap);
        }
        ServletOutputStream os = response.getOutputStream();
        response.setContentType("text/javascript;charset=UTF-8");
        os.write(("var localeData =" + messages).getBytes("UTF-8"));
    }

    private String getParamFromQuery(ServletRequest request, String paramName) {
        String localepath;
        HttpServletRequest res = (HttpServletRequest)request;
        String queryStr = res.getQueryString();
        return localepath.substring(0, (localepath = queryStr.substring(queryStr.indexOf(paramName) + paramName.length() + 1, queryStr.length())).indexOf("/") > 0 ? localepath.indexOf("/") : localepath.length());
    }

    public void destroy() {
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }
}

