/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vipclient.i18n.l2.text;

import com.vmware.vipclient.i18n.I18nFactory;
import com.vmware.vipclient.i18n.base.instances.NumberFormatting;
import com.vmware.vipclient.i18n.exceptions.VIPUncheckedIOException;
import com.vmware.vipclient.i18n.l2.plural.parser.PluralRules;
import com.vmware.vipclient.i18n.l2.text.MessagePattern;
import com.vmware.vipclient.i18n.l2.text.PluralFormat;
import com.vmware.vipclient.i18n.util.LocaleUtility;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.text.AttributedCharacterIterator;
import java.text.CharacterIterator;
import java.text.FieldPosition;
import java.text.Format;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class MessageFormat {
    private Locale locale;
    private transient MessagePattern msgPattern;
    private transient Map<Integer, Format> cachedFormatters;
    private transient PluralSelectorProvider pluralProvider;
    private transient PluralSelectorProvider ordinalProvider;

    public MessageFormat() {
    }

    public MessageFormat(String pattern) {
        this.locale = LocaleUtility.getDefaultLocale();
        this.applyPattern(pattern);
    }

    public MessageFormat(String pattern, Locale locale) {
        this.locale = locale;
        this.applyPattern(pattern);
    }

    public void applyPattern(String pttrn) {
        try {
            if (this.msgPattern == null) {
                this.msgPattern = new MessagePattern(pttrn);
            } else {
                this.msgPattern.parse(pttrn);
            }
        }
        catch (RuntimeException e) {
            this.resetPattern();
            throw e;
        }
    }

    public void applyPattern(String pattern, MessagePattern.ApostropheMode aposMode) {
        if (this.msgPattern == null) {
            this.msgPattern = new MessagePattern(aposMode);
        } else if (aposMode != this.msgPattern.getApostropheMode()) {
            this.msgPattern.clearPatternAndSetApostropheMode(aposMode);
        }
        this.applyPattern(pattern);
    }

    public final StringBuilder format(Object[] arguments, StringBuilder result, FieldPosition pos) {
        this.format(arguments, null, new AppendableWrapper(result), pos);
        return result;
    }

    public final StringBuilder format(Map<String, Object> arguments, StringBuilder result, FieldPosition pos) {
        this.format(null, arguments, new AppendableWrapper(result), pos);
        return result;
    }

    private void format(Object[] arguments, Map<String, Object> argsMap, AppendableWrapper dest, FieldPosition fp) {
        if (arguments != null && this.msgPattern.hasNamedArguments()) {
            throw new IllegalArgumentException("This method is not available in MessageFormat objects that use alphanumeric argument names.");
        }
        this.format(0, null, arguments, argsMap, dest, fp);
    }

    private void format(int msgStart, PluralSelectorContext pluralNumber, Object[] args, Map<String, Object> argsMap, AppendableWrapper dest, FieldPosition fp) {
        String msgString = this.msgPattern.getPatternString();
        int prevIndex = this.msgPattern.getPart(msgStart).getLimit();
        int i = msgStart + 1;
        while (true) {
            MessagePattern.Part part = this.msgPattern.getPart(i);
            MessagePattern.Part.Type type = part.getType();
            int index = part.getIndex();
            dest.append(msgString, prevIndex, index);
            if (type == MessagePattern.Part.Type.MSG_LIMIT) {
                return;
            }
            prevIndex = part.getLimit();
            if (type == MessagePattern.Part.Type.REPLACE_NUMBER) {
                if (pluralNumber.forReplaceNumber) {
                    dest.formatAndAppend(pluralNumber.formatter, pluralNumber.number, pluralNumber.numberString);
                } else {
                    I18nFactory factory = I18nFactory.getInstance();
                    NumberFormatting p = (NumberFormatting)factory.getFormattingInstance(NumberFormatting.class);
                    dest.append(p.formatNumber(pluralNumber.number, this.locale));
                }
            } else if (type == MessagePattern.Part.Type.ARG_START) {
                Map dataMap = this.formatArg(pluralNumber, args, argsMap, dest, fp, i);
                prevIndex = (Integer)dataMap.get("prevIndex");
                i = (Integer)dataMap.get("argLimit");
            }
            ++i;
        }
    }

    private Map formatArg(PluralSelectorContext pluralNumber, Object[] args, Map<String, Object> argsMap, AppendableWrapper dest, FieldPosition fp, int i) {
        HashMap<String, Integer> dataMap = new HashMap<String, Integer>();
        int argLimit = this.msgPattern.getLimitPartIndex(i);
        MessagePattern.Part part = this.msgPattern.getPart(++i);
        String argName = this.msgPattern.getSubstring(part);
        Map<String, Object> argMap = this.getArgValue(args, argsMap, dest, part);
        Object argId = argMap.get("argId");
        int prevDestLength = dest.length;
        this.format(pluralNumber, ++i, argName, argMap, args, argsMap, dest);
        this.updateMetaData(dest, prevDestLength, fp, argId);
        int prevIndex = this.msgPattern.getPart(argLimit).getLimit();
        dataMap.put("argLimit", argLimit);
        dataMap.put("prevIndex", prevIndex);
        return dataMap;
    }

    private Map<String, Object> getArgValue(Object[] args, Map<String, Object> argsMap, AppendableWrapper dest, MessagePattern.Part part) {
        Object arg;
        HashMap<String, Object> map = new HashMap<String, Object>();
        boolean noArg = false;
        Object argId = null;
        String argName = this.msgPattern.getSubstring(part);
        if (args != null) {
            int argNumber = part.getValue();
            if (dest.attributes != null) {
                argId = argNumber;
            }
            if (0 <= argNumber && argNumber < args.length) {
                arg = args[argNumber];
            } else {
                arg = null;
                noArg = true;
            }
        } else {
            argId = argName;
            if (argsMap != null && argsMap.containsKey(argName)) {
                arg = argsMap.get(argName);
            } else {
                arg = null;
                noArg = true;
            }
        }
        map.put("noArg", noArg);
        map.put("argId", argId);
        map.put("arg", arg);
        return map;
    }

    private void format(PluralSelectorContext pluralNumber, int i, String argName, Map map, Object[] args, Map<String, Object> argsMap, AppendableWrapper dest) {
        Object formatter = null;
        MessagePattern.Part part = this.msgPattern.getPart(i - 2);
        MessagePattern.ArgType argType = part.getArgType();
        Object arg = map.get("arg");
        boolean noArg = (Boolean)map.get("noArg");
        if (noArg) {
            dest.append("{" + argName + "}");
        } else if (arg == null) {
            dest.append("null");
        } else if (pluralNumber != null && pluralNumber.numberArgIndex == i - 2) {
            if (pluralNumber.offset == 0.0) {
                dest.formatAndAppend(pluralNumber.formatter, pluralNumber.number, pluralNumber.numberString);
            } else {
                dest.formatAndAppend(pluralNumber.formatter, arg);
            }
        } else if (argType == MessagePattern.ArgType.NONE || this.cachedFormatters != null && this.cachedFormatters.containsKey(i - 2)) {
            dest.append(arg.toString());
        } else if (argType.hasPluralStyle()) {
            this.formatPluralOrSelectMsg(argType, i, argName, arg, args, argsMap, dest);
        } else {
            throw new IllegalStateException("unexpected argType " + (Object)((Object)argType));
        }
    }

    private void formatPluralOrSelectMsg(MessagePattern.ArgType argType, int i, String argName, Object arg, Object[] args, Map<String, Object> argsMap, AppendableWrapper dest) {
        PluralSelectorProvider selector;
        if (!(arg instanceof Number)) {
            throw new IllegalArgumentException("'" + arg + "' is not a Number");
        }
        if (argType == MessagePattern.ArgType.PLURAL) {
            if (this.pluralProvider == null) {
                this.pluralProvider = new PluralSelectorProvider(this, PluralRules.PluralType.CARDINAL);
            }
            selector = this.pluralProvider;
        } else {
            if (this.ordinalProvider == null) {
                this.ordinalProvider = new PluralSelectorProvider(this, PluralRules.PluralType.ORDINAL);
            }
            selector = this.ordinalProvider;
        }
        Number number = (Number)arg;
        double offset = this.msgPattern.getPluralOffset(i);
        PluralSelectorContext context = new PluralSelectorContext(i, argName, number, offset);
        int subMsgStart = PluralFormat.findSubMessage(this.msgPattern, i, selector, context, number.doubleValue());
        this.formatComplexSubMessage(subMsgStart, context, args, argsMap, dest);
    }

    private void formatComplexSubMessage(int msgStart, PluralSelectorContext pluralNumber, Object[] args, Map<String, Object> argsMap, AppendableWrapper dest) {
        if (!this.msgPattern.jdkAposMode()) {
            this.format(msgStart, pluralNumber, args, argsMap, dest, null);
            return;
        }
    }

    private FieldPosition updateMetaData(AppendableWrapper dest, int prevLength, FieldPosition fp, Object argId) {
        if (dest.attributes != null && prevLength < dest.length) {
            dest.attributes.add(new AttributeAndPosition(argId, prevLength, dest.length));
        }
        if (fp != null && Field2.ARGUMENT.equals(fp.getFieldAttribute())) {
            fp.setBeginIndex(prevLength);
            fp.setEndIndex(dest.length);
            return null;
        }
        return fp;
    }

    private void resetPattern() {
        if (this.msgPattern != null) {
            this.msgPattern.clear();
        }
        if (this.cachedFormatters != null) {
            this.cachedFormatters.clear();
        }
    }

    private static final class AttributeAndPosition {
        private AttributedCharacterIterator.Attribute key;
        private Object value;
        private int start;
        private int limit;

        public AttributeAndPosition(Object fieldValue, int startIndex, int limitIndex) {
            this.init(Field2.ARGUMENT, fieldValue, startIndex, limitIndex);
        }

        public AttributeAndPosition(AttributedCharacterIterator.Attribute field, Object fieldValue, int startIndex, int limitIndex) {
            this.init(field, fieldValue, startIndex, limitIndex);
        }

        public void init(AttributedCharacterIterator.Attribute field, Object fieldValue, int startIndex, int limitIndex) {
            this.key = field;
            this.value = fieldValue;
            this.start = startIndex;
            this.limit = limitIndex;
        }

        public void redundantMethod() {
            if (this.key == null) {
                // empty if block
            }
            if (this.value == null) {
                // empty if block
            }
            if (this.start == 0) {
                // empty if block
            }
            if (this.limit == 0) {
                // empty if block
            }
        }
    }

    private static final class AppendableWrapper {
        private Appendable app;
        private int length;
        private List<AttributeAndPosition> attributes;

        public AppendableWrapper(StringBuilder sb) {
            this.app = sb;
            this.length = sb.length();
            this.attributes = null;
        }

        public void useAttributes() {
            this.attributes = new ArrayList<AttributeAndPosition>();
        }

        public void append(CharSequence s) {
            try {
                this.app.append(s);
                this.length += s.length();
            }
            catch (IOException e) {
                throw new VIPUncheckedIOException(e);
            }
        }

        public void append(CharSequence s, int start, int limit) {
            try {
                this.app.append(s, start, limit);
                this.length += limit - start;
            }
            catch (IOException e) {
                throw new VIPUncheckedIOException(e);
            }
        }

        public void append(CharacterIterator iterator) {
            this.length += AppendableWrapper.append(this.app, iterator);
        }

        public static int append(Appendable result, CharacterIterator iterator) {
            try {
                int start = iterator.getBeginIndex();
                int limit = iterator.getEndIndex();
                int length = limit - start;
                if (start < limit) {
                    result.append(iterator.first());
                    while (++start < limit) {
                        result.append(iterator.next());
                    }
                }
                return length;
            }
            catch (IOException e) {
                throw new VIPUncheckedIOException(e);
            }
        }

        public void formatAndAppend(Format formatter, Object arg) {
            if (this.attributes == null) {
                this.append(formatter.format(arg));
            } else {
                AttributedCharacterIterator formattedArg = formatter.formatToCharacterIterator(arg);
                int prevLength = this.length;
                this.append(formattedArg);
                formattedArg.first();
                int start = formattedArg.getIndex();
                int limit = formattedArg.getEndIndex();
                int offset = prevLength - start;
                while (start < limit) {
                    Map<AttributedCharacterIterator.Attribute, Object> map = formattedArg.getAttributes();
                    int runLimit = formattedArg.getRunLimit();
                    if (map.size() != 0) {
                        for (Map.Entry<AttributedCharacterIterator.Attribute, Object> entry : map.entrySet()) {
                            this.attributes.add(new AttributeAndPosition(entry.getKey(), entry.getValue(), offset + start, offset + runLimit));
                        }
                    }
                    start = runLimit;
                    formattedArg.setIndex(start);
                }
            }
        }

        public void formatAndAppend(Format formatter, Object arg, String argString) {
            if (this.attributes == null && argString != null) {
                this.append(argString);
            } else {
                this.formatAndAppend(formatter, arg);
            }
        }
    }

    private static final class PluralSelectorProvider
    implements PluralFormat.PluralSelector {
        private MessageFormat msgFormat;
        private PluralRules rules;
        private PluralRules.PluralType type;

        public PluralSelectorProvider(MessageFormat mf, PluralRules.PluralType type) {
            this.msgFormat = mf;
            this.type = type;
        }

        @Override
        public String select(Object ctx, double number) {
            if (this.rules == null) {
                this.rules = PluralRules.forLocale(this.msgFormat.locale, this.type);
            }
            return this.rules.select(number);
        }
    }

    private static final class PluralSelectorContext {
        int startIndex;
        String argName;
        Number number;
        double offset;
        int numberArgIndex;
        Format formatter;
        String numberString;
        boolean forReplaceNumber;

        private PluralSelectorContext(int start, String name, Number num, double off) {
            this.startIndex = start;
            this.argName = name;
            this.number = off == 0.0 ? (Number)num : (Number)(num.doubleValue() - off);
            this.offset = off;
        }

        public String toString() {
            throw new AssertionError((Object)"PluralSelectorContext being formatted, rather than its number");
        }
    }

    public static class Field2
    extends Format.Field {
        private static final long serialVersionUID = 7510380454602616157L;
        public static final Field2 ARGUMENT = new Field2("message argument field");

        protected Field2(String name) {
            super(name);
        }

        @Override
        protected Object readResolve() throws InvalidObjectException {
            if (this.getClass() != Field2.class) {
                throw new InvalidObjectException("A subclass of MessageFormat.Field must implement readResolve.");
            }
            if (this.getName().equals(ARGUMENT.getName())) {
                return ARGUMENT;
            }
            throw new InvalidObjectException("Unknown attribute name.");
        }
    }
}

