/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vipclient.i18n.util;

import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONUtils {
    static Logger logger = LoggerFactory.getLogger(JSONUtils.class);

    public static Map<String, Object> getMapFromJson(String json) {
        Map result = null;
        if (json != null && !"".equals(json)) {
            try {
                JSONObject jsonObject = new JSONObject(json);
                result = jsonObject.toMap();
            }
            catch (JSONException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return result;
    }

    public static Map<String, String> map2SortMap(Map<String, String> jsonMap) {
        if (jsonMap == null || jsonMap.size() == 0) {
            return null;
        }
        TreeMap<String, String> sortMap = new TreeMap<String, String>(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.toLowerCase().compareTo(o2.toLowerCase());
            }
        });
        sortMap.putAll(jsonMap);
        return sortMap;
    }

    public static boolean isEmpty(String json) {
        return json == null || "".equals(json) || "{}".equals(json);
    }
}

