/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cxfrestclient;

import com.vmware.cxfrestclient.CxfClientSecurityContext;
import com.vmware.cxfrestclient.JaxRsClient;
import java.io.File;
import java.net.URI;
import java.util.List;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.xml.bind.JAXBElement;
import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.apache.cxf.jaxrs.client.Client;
import org.apache.cxf.jaxrs.client.ClientConfiguration;
import org.apache.cxf.jaxrs.client.JAXRSClientFactory;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.transport.http.HTTPConduit;

public abstract class AbstractCxfRestClient
implements JaxRsClient {
    protected final URI endpoint;
    private JaxRsClient.ErrorHandler errorHandler;
    private final CxfClientSecurityContext cxfClientSecurityContext;

    protected AbstractCxfRestClient(URI endpoint) {
        this(endpoint, CxfClientSecurityContext.getDefaultCxfClientSecurityContext());
    }

    protected AbstractCxfRestClient(URI endpoint, CxfClientSecurityContext cxfClientSecurityContext) {
        this.endpoint = endpoint;
        this.cxfClientSecurityContext = cxfClientSecurityContext;
    }

    protected AbstractCxfRestClient(AbstractCxfRestClient client) {
        this(client.endpoint, client.cxfClientSecurityContext);
    }

    protected AbstractCxfRestClient(URI endpoint, AbstractCxfRestClient client) {
        this(endpoint, client.cxfClientSecurityContext);
    }

    protected abstract List<?> getCxfProviders();

    protected abstract void configureHttpRequestHeaders(Client var1);

    @Override
    public <JaxRsClass> JaxRsClass createProxy(Class<JaxRsClass> jaxRsClass) {
        Object proxy = JAXRSClientFactory.create((String)this.endpoint.toString(), jaxRsClass, this.getCxfProviders(), (boolean)true);
        this.configureClient(proxy);
        return (JaxRsClass)proxy;
    }

    @Override
    public URI getEndpoint() {
        return this.endpoint;
    }

    private boolean handleException(URI uri, WebApplicationException e, int failureCount) {
        return this.errorHandler != null && this.errorHandler.handleError(this, uri, e, failureCount) == JaxRsClient.ErrorHandler.Disposition.RETRY;
    }

    @Override
    public Response getResource(URI uri) {
        int failureCount = 0;
        while (true) {
            try {
                return this.createWebClient(uri).get();
            }
            catch (WebApplicationException e) {
                if (this.handleException(uri, e, ++failureCount)) continue;
                throw this.makeException(e);
            }
            break;
        }
    }

    @Override
    public <ResourceClass> ResourceClass getResource(URI uri, Class<ResourceClass> resourceClass) {
        int failureCount = 0;
        while (true) {
            try {
                return (ResourceClass)this.createWebClient(uri).get(resourceClass);
            }
            catch (WebApplicationException e) {
                if (this.handleException(uri, e, ++failureCount)) continue;
                throw this.makeException(e);
            }
            break;
        }
    }

    @Override
    public <ContentsClass> Response putResource(URI uri, String type, JAXBElement<ContentsClass> contents) {
        int failureCount = 0;
        while (true) {
            try {
                return this.createWebClient(uri, type).put(contents);
            }
            catch (WebApplicationException e) {
                if (this.handleException(uri, e, ++failureCount)) continue;
                throw this.makeException(e);
            }
            break;
        }
    }

    @Override
    public <ContentsClass> void putResourceVoid(URI uri, String type, JAXBElement<ContentsClass> contents) {
        Response response = this.putResource(uri, type, contents);
        this.handleNoContentResponse(response);
    }

    private void handleNoContentResponse(Response response) {
        if (response.getStatus() != 204) {
            throw this.makeException(new WebApplicationException(response));
        }
    }

    @Override
    public <ContentsClass, ResponseClass> ResponseClass putResource(URI uri, String type, JAXBElement<ContentsClass> contents, Class<ResponseClass> responseClass) {
        int failureCount = 0;
        while (true) {
            try {
                return (ResponseClass)this.createWebClient(uri, type).invoke("PUT", contents, responseClass);
            }
            catch (WebApplicationException e) {
                if (this.handleException(uri, e, ++failureCount)) continue;
                throw this.makeException(e);
            }
            break;
        }
    }

    @Override
    public Response putFile(URI uri, File file, String type) {
        int failureCount = 0;
        while (true) {
            try {
                Response put = this.createWebClient(uri, type).put((Object)file);
                return put;
            }
            catch (WebApplicationException e) {
                if (this.handleException(uri, e, ++failureCount)) continue;
                throw e;
            }
            break;
        }
    }

    @Override
    public <ContentsClass> Response postResource(URI uri, String type, JAXBElement<ContentsClass> contents) {
        int failureCount = 0;
        while (true) {
            try {
                return this.createWebClient(uri, type).post(contents);
            }
            catch (WebApplicationException e) {
                if (this.handleException(uri, e, ++failureCount)) continue;
                throw this.makeException(e);
            }
            break;
        }
    }

    @Override
    public <ContentsClass> void postResourceVoid(URI uri, String type, JAXBElement<ContentsClass> contents) {
        Response response = this.postResource(uri, type, contents);
        this.handleNoContentResponse(response);
    }

    @Override
    public <ContentsClass, ResponseClass> ResponseClass postResource(URI uri, String type, JAXBElement<ContentsClass> contents, Class<ResponseClass> responseClass) {
        int failureCount = 0;
        while (true) {
            try {
                return (ResponseClass)this.createWebClient(uri, type).post(contents, responseClass);
            }
            catch (WebApplicationException e) {
                if (this.handleException(uri, e, ++failureCount)) continue;
                throw this.makeException(e);
            }
            break;
        }
    }

    @Override
    public Response deleteResource(URI uri) {
        int failureCount = 0;
        while (true) {
            try {
                return this.createWebClient(uri).delete();
            }
            catch (WebApplicationException e) {
                if (this.handleException(uri, e, ++failureCount)) continue;
                throw this.makeException(e);
            }
            break;
        }
    }

    protected RuntimeException makeException(WebApplicationException exception) {
        throw exception;
    }

    @Override
    public void deleteResourceVoid(URI uri) {
        Response response = this.deleteResource(uri);
        this.handleNoContentResponse(response);
    }

    @Override
    public <ResponseClass> ResponseClass deleteResource(URI uri, Class<ResponseClass> responseClass) {
        int failureCount = 0;
        while (true) {
            try {
                return (ResponseClass)this.createWebClient(uri).invoke("DELETE", null, responseClass);
            }
            catch (WebApplicationException e) {
                if (this.handleException(uri, e, ++failureCount)) continue;
                throw this.makeException(e);
            }
            break;
        }
    }

    @Override
    public Response optionsResource(URI uri) {
        int failureCount = 0;
        while (true) {
            try {
                return this.createWebClient(uri).invoke("OPTIONS", null);
            }
            catch (WebApplicationException e) {
                if (this.handleException(uri, e, ++failureCount)) continue;
                throw this.makeException(e);
            }
            break;
        }
    }

    @Override
    public WebClient createWebClient(URI uri) {
        return this.createWebClient(uri, null);
    }

    @Override
    public WebClient createWebClient(URI uri, String type) {
        WebClient client = WebClient.create((String)uri.toASCIIString(), this.getCxfProviders());
        if (type != null) {
            client.type(type);
        }
        this.configureClient(client);
        return client;
    }

    @Override
    public void setErrorHandler(JaxRsClient.ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    private void configureHttpRequestHeaders(Object proxy) {
        this.configureHttpRequestHeaders(WebClient.client((Object)proxy));
    }

    protected final void configureSSLTrustManager(ClientConfiguration config) {
        HTTPConduit httpConduit = (HTTPConduit)config.getConduit();
        TLSClientParameters tlsParams = new TLSClientParameters();
        tlsParams.setUseHttpsURLConnectionDefaultSslSocketFactory(false);
        tlsParams.setSSLSocketFactory(this.cxfClientSecurityContext.getSSLSocketFactory());
        if (this.cxfClientSecurityContext.isHostnameVerificationEnabled()) {
            tlsParams.setUseHttpsURLConnectionDefaultHostnameVerifier(true);
        } else {
            tlsParams.setDisableCNCheck(true);
        }
        httpConduit.setTlsClientParameters(tlsParams);
    }

    private void addHttpChunking(ClientConfiguration config) {
        HTTPConduit httpConduit = (HTTPConduit)config.getConduit();
        httpConduit.getClient().setAllowChunking(true);
    }

    private void adjustConfiguration(ClientConfiguration config) {
        this.configureSSLTrustManager(config);
        this.addHttpChunking(config);
    }

    protected void configureClient(Object client) {
        this.adjustConfiguration(WebClient.getConfig((Object)client));
        this.configureHttpRequestHeaders(client);
    }
}

