/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cxfrestclient;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;

public final class CxfClientSecurityContext {
    private static final X509TrustManager[] DEFAULT_TRUST_MANAGER = null;
    private static final X509KeyManager[] DEFAULT_KEY_MANAGER = null;
    public static final Collection<String> DEFAULT_PROTOCOL_LIST = null;
    public static final Collection<String> DEFAULT_CIPHER_LIST = null;
    private final boolean enableHostnameVerification;
    private final SSLSocketFactory sslSocketFactory;

    private CxfClientSecurityContext() {
        this.sslSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
        this.enableHostnameVerification = true;
    }

    private CxfClientSecurityContext(KeyManager[] keyManagers, TrustManager[] trustManagers, Collection<String> protocols, Collection<String> ciphers, boolean enableHostnameVerification) throws GeneralSecurityException {
        this.enableHostnameVerification = enableHostnameVerification;
        this.sslSocketFactory = this.createRestrictedSocketFactory(keyManagers, trustManagers, protocols, ciphers);
    }

    private CxfClientSecurityContext(SSLSocketFactory sslSocketFactory, boolean enableHostnameVerification) {
        this.enableHostnameVerification = enableHostnameVerification;
        this.sslSocketFactory = sslSocketFactory;
    }

    public static CxfClientSecurityContext getDefaultCxfClientSecurityContext() {
        return new CxfClientSecurityContext();
    }

    public static CxfClientSecurityContext getCxfClientSecurityContext(KeyStore keystore, char[] keyPassword, KeyStore truststore, Collection<String> ciphers, boolean enableHostnameVerification) throws GeneralSecurityException {
        return CxfClientSecurityContext.getCxfClientSecurityContext(keystore, keyPassword, truststore, DEFAULT_PROTOCOL_LIST, ciphers, enableHostnameVerification);
    }

    public static CxfClientSecurityContext getCxfClientSecurityContext(KeyStore keystore, char[] keyPassword, KeyStore truststore, Collection<String> protocols, Collection<String> ciphers, boolean enableHostnameVerification) throws GeneralSecurityException {
        KeyManager[] keyManagers = CxfClientSecurityContext.getKeyManagers(keystore, keyPassword);
        TrustManager[] trustManagers = CxfClientSecurityContext.getTrustManagers(truststore);
        return new CxfClientSecurityContext(keyManagers, trustManagers, protocols, ciphers, enableHostnameVerification);
    }

    public static CxfClientSecurityContext getCxfClientSecurityContext(SSLSocketFactory sslSocketFactory, boolean enableHostnameVerification) {
        return new CxfClientSecurityContext(sslSocketFactory, enableHostnameVerification);
    }

    private static TrustManager[] getTrustManagers(KeyStore truststore) throws KeyStoreException {
        TrustManagerFactory trustManagerFactory;
        if (truststore == null) {
            return DEFAULT_TRUST_MANAGER;
        }
        try {
            trustManagerFactory = TrustManagerFactory.getInstance("PKIX");
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new AssertionError("Required Trust Manager algorithm PKIX unavailable on this system", nsae);
        }
        trustManagerFactory.init(truststore);
        return trustManagerFactory.getTrustManagers();
    }

    private static KeyManager[] getKeyManagers(KeyStore keystore, char[] keyPassword) throws GeneralSecurityException {
        KeyManagerFactory keyManagerFactory;
        if (keystore == null) {
            return DEFAULT_KEY_MANAGER;
        }
        try {
            keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new AssertionError("Required Key Manager algorithm SunX509 unavailable on this system", nsae);
        }
        keyManagerFactory.init(keystore, keyPassword);
        return keyManagerFactory.getKeyManagers();
    }

    final boolean isHostnameVerificationEnabled() {
        return this.enableHostnameVerification;
    }

    public final SSLSocketFactory getSSLSocketFactory() {
        return this.sslSocketFactory;
    }

    private static String getTLSVersionForJava() {
        String javaVersionStr = System.getProperty("java.version");
        String[] versionParts = javaVersionStr.split("\\.");
        if (Integer.parseInt(versionParts[0]) == 1) {
            int javaMajorVersion = Integer.parseInt(versionParts[1]);
            if (javaMajorVersion >= 8) {
                return "TLS";
            }
            if (javaMajorVersion == 7) {
                return "TLSv1.2";
            }
        }
        throw new UnsupportedOperationException("Java version " + javaVersionStr + " is not supported. Java 1.7 or later required");
    }

    private SSLSocketFactory createRestrictedSocketFactory(KeyManager[] keyManagers, TrustManager[] trustManagers, Collection<String> protocols, Collection<String> ciphers) throws GeneralSecurityException {
        SSLContext restrictedSSLContext = SSLContext.getInstance(CxfClientSecurityContext.getTLSVersionForJava());
        restrictedSSLContext.init(keyManagers, trustManagers, new SecureRandom());
        return new RestrictedSSLSocketFactory(restrictedSSLContext.getSocketFactory(), protocols, ciphers);
    }

    public int hashCode() {
        return Objects.hash(this.enableHostnameVerification, this.sslSocketFactory);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CxfClientSecurityContext)) {
            return false;
        }
        CxfClientSecurityContext other = (CxfClientSecurityContext)obj;
        return Objects.equals(this.enableHostnameVerification, other.enableHostnameVerification) && Objects.equals(this.sslSocketFactory, other.sslSocketFactory);
    }

    public String toString() {
        return String.format("[CxfClientSecurityContext] SSLSocketFactory = %s,\nHostname verification is %s.", this.sslSocketFactory, this.enableHostnameVerification ? "enabled" : "disabled");
    }

    private static final class RestrictedSSLSocketFactory
    extends SSLSocketFactory {
        private final SSLSocketFactory sslSocketFactory;
        private final Set<String> protocols;
        private final String[] ciphers;

        public RestrictedSSLSocketFactory(SSLSocketFactory sslSocketFactory, Collection<String> protocols, Collection<String> ciphers) {
            this.sslSocketFactory = sslSocketFactory;
            this.protocols = protocols == null ? null : new HashSet<String>(protocols);
            this.ciphers = RestrictedSSLSocketFactory.intersectionOf(ciphers, sslSocketFactory.getSupportedCipherSuites());
        }

        @Override
        public String[] getDefaultCipherSuites() {
            return this.ciphers;
        }

        @Override
        public String[] getSupportedCipherSuites() {
            return this.ciphers;
        }

        @Override
        public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
            return this.restrict((SSLSocket)this.sslSocketFactory.createSocket(s, host, port, autoClose));
        }

        @Override
        public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
            return this.restrict((SSLSocket)this.sslSocketFactory.createSocket(host, port));
        }

        @Override
        public Socket createSocket(InetAddress host, int port) throws IOException {
            return this.restrict((SSLSocket)this.sslSocketFactory.createSocket(host, port));
        }

        @Override
        public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
            return this.restrict((SSLSocket)this.sslSocketFactory.createSocket(host, port, localHost, localPort));
        }

        @Override
        public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
            return this.restrict((SSLSocket)this.sslSocketFactory.createSocket(address, port, localAddress, localPort));
        }

        private SSLSocket restrict(SSLSocket socket) {
            socket.setEnabledProtocols(RestrictedSSLSocketFactory.intersectionOf(this.protocols, socket.getEnabledProtocols()));
            socket.setEnabledCipherSuites(this.ciphers);
            return socket;
        }

        private static String[] intersectionOf(Collection<String> configured, String[] supported) {
            if (configured == null) {
                return supported;
            }
            HashSet<String> resultSet = new HashSet<String>(Arrays.asList(supported));
            resultSet.retainAll(configured);
            return resultSet.toArray(new String[resultSet.size()]);
        }
    }
}

