/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcloud.api.rest.client;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import com.vmware.vcloud.api.rest.client.AbstractVcdClientBase;
import com.vmware.vcloud.api.rest.client.OpenApiClient;
import com.vmware.vcloud.api.rest.client.VcdClientImpl;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.cxf.jaxrs.client.Client;
import org.apache.cxf.jaxrs.client.WebClient;

class OpenApiClientImpl
extends AbstractVcdClientBase
implements OpenApiClient {
    private final VcdClientImpl parentVcdClient;

    OpenApiClientImpl(VcdClientImpl vcdClient) {
        super(vcdClient.getOpenApiEndpoint(), vcdClient);
        this.parentVcdClient = vcdClient;
    }

    @Override
    protected List<?> getCxfProviders() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        JacksonJsonProvider provider = new JacksonJsonProvider(mapper);
        return Collections.singletonList(provider);
    }

    @Override
    protected void setAuthenticationHeaders(Client client) {
        this.parentVcdClient.setAuthenticationHeaders(client);
    }

    @Override
    protected String[] getAcceptHeaders() {
        return new String[]{"application/json"};
    }

    @Override
    public <JaxRsClass> JaxRsClass createProxy(Class<JaxRsClass> jaxrsApiInterface) {
        if (!jaxrsApiInterface.isInterface()) {
            throw new IllegalArgumentException(String.format("Class %s to proxy must be an interface", jaxrsApiInterface.getName()));
        }
        Object proxiedProxy = Proxy.newProxyInstance(jaxrsApiInterface.getClassLoader(), new Class[]{jaxrsApiInterface}, new SingleUseProxyInvoker<JaxRsClass>(jaxrsApiInterface, this));
        return (JaxRsClass)proxiedProxy;
    }

    public <JaxRsProxy> Client getWebClientForNextCall(JaxRsProxy proxy) {
        SingleUseProxyInvoker invocationHandler = (SingleUseProxyInvoker)Proxy.getInvocationHandler(proxy);
        return invocationHandler.getNextCallClient();
    }

    private static final class SingleUseProxyInvoker<JaxRsApi>
    extends AbstractVcdClientBase
    implements InvocationHandler {
        private final OpenApiClientImpl parentClient;
        private final Class<JaxRsApi> api;
        private final AtomicReference<JaxRsApi> apiProxy = new AtomicReference<Object>(null);

        SingleUseProxyInvoker(Class<JaxRsApi> api, OpenApiClientImpl parentClient) {
            super(parentClient);
            this.parentClient = parentClient;
            this.api = api;
            this.resetWebClientProxy();
        }

        private void resetWebClientProxy() {
            this.apiProxy.set(null);
        }

        private JaxRsApi getCurrentClientProxy() {
            this.apiProxy.compareAndSet(null, this.createProxy(this.api));
            return this.apiProxy.get();
        }

        Client getNextCallClient() {
            return WebClient.client(this.getCurrentClientProxy());
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                Object object = method.invoke(this.getCurrentClientProxy(), args);
                return object;
            }
            catch (InvocationTargetException ite) {
                throw ite.getCause();
            }
            finally {
                this.resetWebClientProxy();
            }
        }

        @Override
        protected void setAuthenticationHeaders(Client client) {
            this.parentClient.setAuthenticationHeaders(client);
        }

        @Override
        protected String[] getAcceptHeaders() {
            return new String[0];
        }

        @Override
        protected List<?> getCxfProviders() {
            return this.parentClient.getCxfProviders();
        }
    }
}

