/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcloud.api.rest.client;

import com.vmware.cxfrestclient.JaxRsClient;
import com.vmware.vcloud.api.rest.client.TaskMonitor;
import com.vmware.vcloud.api.rest.client.TaskStatus;
import com.vmware.vcloud.api.rest.client.VcdTaskException;
import com.vmware.vcloud.api.rest.schema_v1_5.EntityType;
import com.vmware.vcloud.api.rest.schema_v1_5.TaskType;
import com.vmware.vcloud.api.rest.schema_v1_5.TasksInProgressType;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang3.time.StopWatch;

public class TaskMonitorImpl
implements TaskMonitor {
    private final JaxRsClient client;
    private static final long DEFAULT_POLL_MS = TimeUnit.MILLISECONDS.convert(5L, TimeUnit.SECONDS);

    public TaskMonitorImpl(JaxRsClient client) {
        this.client = client;
    }

    @Override
    public TaskType waitForSuccess(TaskType task, long timeoutInMillis) throws TimeoutException {
        return this.waitForStatus(task, timeoutInMillis, DEFAULT_POLL_MS, TaskStatus.ERROR, TaskStatus.SUCCESS);
    }

    @Override
    public TaskType waitForSuccess(String taskHref, long timeoutInMillis) throws TimeoutException {
        return this.waitForStatus(taskHref, timeoutInMillis, DEFAULT_POLL_MS, TaskStatus.ERROR, TaskStatus.SUCCESS);
    }

    @Override
    public TaskType waitForSuccess(EntityType entity, long timeoutInMillis) throws TimeoutException {
        TasksInProgressType tasks = entity.getTasks();
        if (tasks.getTask().size() != 1) {
            throw new IllegalStateException("Entity doesn't have exactly one task");
        }
        TaskType task = (TaskType)tasks.getTask().get(0);
        return this.waitForSuccess(task, timeoutInMillis);
    }

    @Override
    public TaskType waitForStatus(TaskType task, long timeoutInMillis, long pollFrequency, TaskStatus failOnStatus, TaskStatus ... expectedTargetStatus) throws TimeoutException {
        String taskHref = task.getHref();
        return this.waitForStatus(taskHref, timeoutInMillis, pollFrequency, failOnStatus, expectedTargetStatus);
    }

    @Override
    public TaskType waitForStatus(String taskHref, long timeoutInMillis, long pollFrequency, TaskStatus failOnStatus, TaskStatus ... expectedTargetStatus) throws TimeoutException {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        while (true) {
            TaskType taskType = this.getTaskStatus(taskHref);
            for (TaskStatus status : expectedTargetStatus) {
                if (taskType.getStatus().equalsIgnoreCase(status.toString())) {
                    return taskType;
                }
                if (failOnStatus == null || !taskType.getStatus().equalsIgnoreCase(failOnStatus.toString())) continue;
                throw new VcdTaskException(taskType.getOwner(), String.format("Expected task status %s but got %s", this.createTaskStatusString(expectedTargetStatus), taskType.getStatus()), taskType.getError());
            }
            if (stopWatch.getTime() >= timeoutInMillis) break;
            try {
                Thread.sleep(pollFrequency);
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Polling was interrupted", e);
            }
        }
        stopWatch.stop();
        long waitInSeconds = TimeUnit.MILLISECONDS.toSeconds(stopWatch.getTime());
        throw new TimeoutException("Timed out after " + waitInSeconds + " seconds waiting for task: " + taskHref);
    }

    private String createTaskStatusString(TaskStatus ... taskStatus) {
        StringBuffer sb = new StringBuffer();
        for (TaskStatus task : taskStatus) {
            sb.append(task.toString());
            sb.append(", ");
        }
        return sb.toString();
    }

    private TaskType getTaskStatus(String taskHref) {
        return this.client.getResource(TaskMonitorImpl.makeUri(taskHref), TaskType.class);
    }

    private static URI makeUri(String uriString) {
        try {
            return new URI(uriString);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Can't build URI from resource href: " + uriString);
        }
    }
}

