/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcloud.api.rest.client;

import javax.ws.rs.WebApplicationException;

public abstract class VcdErrorException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private final int httpStatusCode;

    protected VcdErrorException(int httpStatusCode, WebApplicationException cause) {
        super(cause);
        this.httpStatusCode = httpStatusCode;
    }

    public final int getHttpStatusCode() {
        return this.httpStatusCode;
    }

    @Override
    public final WebApplicationException getCause() {
        return (WebApplicationException)super.getCause();
    }

    @Override
    public String toString() {
        String newLine = System.getProperty("line.separator");
        StringBuilder builder = new StringBuilder();
        builder.append("VcdErrorException [HTTP status code = ").append(this.httpStatusCode).append("]").append(newLine);
        builder.append("Original cause: ").append(newLine).append((Object)this.getCause());
        return builder.toString();
    }

    @Override
    public String getMessage() {
        return String.format("Error reported by VCD. HTTP status code: %d\nError message: %s", this.getHttpStatusCode(), this.getCause().getMessage());
    }
}

