/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcloud.api.rest.client;

import com.vmware.vcloud.api.rest.client.MissingLinkException;
import com.vmware.vcloud.api.rest.client.MultipleLinksException;
import com.vmware.vcloud.api.rest.links.LinkRelation;
import com.vmware.vcloud.api.rest.schema_v1_5.EntityType;
import com.vmware.vcloud.api.rest.schema_v1_5.IdentifiableResourceType;
import com.vmware.vcloud.api.rest.schema_v1_5.LinkType;
import com.vmware.vcloud.api.rest.schema_v1_5.ReferenceType;
import com.vmware.vcloud.api.rest.schema_v1_5.ResourceType;
import com.vmware.vcloud.api.rest.schema_v1_5.TaskType;
import com.vmware.vcloud.api.rest.schema_v1_5.TasksInProgressType;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.UriBuilder;

public class VcdUtils {
    public static URI buildDeleteUri(URI baseHref, Boolean force, Boolean recursive) {
        UriBuilder builder = UriBuilder.fromUri((URI)baseHref);
        if (force != null) {
            builder.queryParam("force", new Object[]{force});
        }
        if (recursive != null) {
            builder.queryParam("recursive", new Object[]{recursive});
        }
        return builder.build(new Object[0]);
    }

    public static String getEntityId(EntityType entityType) {
        return entityType.getId().split(":")[3];
    }

    public static LinkType findLink(ResourceType resource, LinkRelation rel, String mediaType) throws MissingLinkException, MultipleLinksException {
        return VcdUtils.findLink(resource, rel, mediaType, true);
    }

    public static LinkType findLink(ResourceType resource, LinkRelation rel, String mediaType, boolean failIfAbsent) throws MissingLinkException, MultipleLinksException {
        List<LinkType> links = VcdUtils.getLinks(resource, rel, mediaType);
        switch (links.size()) {
            case 0: {
                if (failIfAbsent) {
                    throw new MissingLinkException(resource.getHref(), rel, mediaType);
                }
                return null;
            }
            case 1: {
                return links.get(0);
            }
        }
        throw new MultipleLinksException(resource.getHref(), rel, mediaType);
    }

    public static List<LinkType> getLinks(ResourceType resource, LinkRelation rel, String mediaType) {
        ArrayList<LinkType> links = new ArrayList<LinkType>();
        for (LinkType link : resource.getLink()) {
            try {
                if (!link.getRel().equals(rel.value())) continue;
                if (mediaType == null && link.getType() == null) {
                    links.add(link);
                    continue;
                }
                if (mediaType == null || !link.getType().equals(mediaType)) continue;
                links.add(link);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return links;
    }

    public static ReferenceType makeRef(ResourceType resource) {
        ReferenceType ref = new ReferenceType();
        ref.setHref(resource.getHref());
        ref.setType(resource.getType());
        return ref;
    }

    public static ReferenceType makeRef(IdentifiableResourceType identifiableResource) {
        ReferenceType ref = VcdUtils.makeRef((ResourceType)identifiableResource);
        ref.setId(identifiableResource.getId());
        return ref;
    }

    public static ReferenceType makeRef(EntityType entity) {
        ReferenceType ref = VcdUtils.makeRef((IdentifiableResourceType)entity);
        ref.setName(entity.getName());
        return ref;
    }

    public static ReferenceType makeRef(LinkType link) {
        ReferenceType ref = new ReferenceType();
        ref.setHref(link.getHref());
        return ref;
    }

    public static ReferenceType makeRef(String href) {
        ReferenceType ref = new ReferenceType();
        ref.setHref(href);
        return ref;
    }

    public static <T extends EntityType> TaskType getTask(T entityType) {
        TasksInProgressType tasks = entityType.getTasks();
        if (tasks == null) {
            throw new RuntimeException("No tasks found. Expected one task");
        }
        List taskList = tasks.getTask();
        if (taskList.size() != 1) {
            throw new RuntimeException("Expected one task, got " + taskList.size());
        }
        return (TaskType)taskList.get(0);
    }
}

