/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcloud.api.rest.client.impl.tasks;

import com.vmware.vcloud.api.rest.client.QueryResultFormat;
import com.vmware.vcloud.api.rest.client.TaskStatus;
import com.vmware.vcloud.api.rest.client.VcdClient;
import com.vmware.vcloud.api.rest.client.VcdTaskMonitor;
import com.vmware.vcloud.api.rest.client.impl.tasks.TaskTimingInfo;
import com.vmware.vcloud.api.rest.schema_v1_5.IdentifiableResourceType;
import com.vmware.vcloud.api.rest.schema_v1_5.QueryResultAdminTaskRecordType;
import com.vmware.vcloud.api.rest.schema_v1_5.QueryResultRecordType;
import com.vmware.vcloud.api.rest.schema_v1_5.QueryResultTaskRecordType;
import com.vmware.vcloud.api.rest.schema_v1_5.TaskType;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.lang3.StringUtils;
import org.apache.cxf.jaxrs.ext.search.client.SearchConditionBuilder;

class VcdBulkTaskMonitor
implements VcdTaskMonitor.MultiTaskTracker {
    private static final long POLLING_INTERVAL_SECS = 15L;
    private final ScheduledExecutorService periodicExecutor = Executors.newSingleThreadScheduledExecutor();
    private final Set<String> taskIds = new HashSet<String>();
    private final Map<String, TaskStatus> taskCompletionStatus = new ConcurrentHashMap<String, TaskStatus>();
    private final VcdClient.Query<? extends QueryResultRecordType> taskQuery;
    private final TaskTimingInfo taskTimingInfo = new TaskTimingInfo();
    private final CompletableFuture<Map<String, TaskStatus>> trackingFuture = new CompletableFuture();
    private final AtomicBoolean allTasksAdded = new AtomicBoolean(false);

    VcdBulkTaskMonitor(VcdClient vcdClient) {
        this.taskQuery = StringUtils.equalsIgnoreCase((CharSequence)vcdClient.getLoggedInOrg().getName(), (CharSequence)"system") ? vcdClient.getQuery("adminTask", QueryResultAdminTaskRecordType.class) : vcdClient.getQuery("task", QueryResultTaskRecordType.class);
        this.taskQuery.setQueryResultFormat(QueryResultFormat.ID_RECORDS).setPageSize(128).setSortAsc("endDate");
        this.periodicExecutor.scheduleWithFixedDelay(() -> this.run(), 15L, 15L, TimeUnit.SECONDS);
        this.trackingFuture.whenComplete(this::finishTracking);
    }

    private final void finishTracking(Map<String, TaskStatus> result, Throwable ex) {
        this.periodicExecutor.shutdown();
    }

    private void run() {
        Date lastKnownEndTime = this.taskTimingInfo.getEndTime();
        if (lastKnownEndTime == null) {
            if (this.allTasksAdded.get()) {
                this.trackingFuture.complete(Collections.emptyMap());
            }
            return;
        }
        String filter = this.generateQueryString(lastKnownEndTime);
        AtomicReference<Date> latestTimeRecorded = new AtomicReference<Date>(lastKnownEndTime);
        try {
            this.taskQuery.setFilter(filter).stream().filter(task -> !this.taskCompletionStatus.containsKey(task.getId())).peek(task -> latestTimeRecorded.set(this.extractEndDate((QueryResultRecordType)task).toGregorianCalendar().getTime())).collect(Collectors.toMap(QueryResultRecordType::getId, task -> TaskStatus.from(this.extractStatus((QueryResultRecordType)task)), (existingTaskStatus, newTaskStatus) -> existingTaskStatus, () -> this.taskCompletionStatus));
        }
        catch (RuntimeException e) {
            this.trackingFuture.completeExceptionally(e);
            throw e;
        }
        this.taskTimingInfo.updateEndTime(latestTimeRecorded.get());
        if (this.allTasksAdded.get() && this.taskCompletionStatus.keySet().containsAll(this.taskIds)) {
            this.taskCompletionStatus.keySet().retainAll(this.taskIds);
            this.trackingFuture.complete(Collections.unmodifiableMap(this.taskCompletionStatus));
        }
    }

    private String generateQueryString(Date lastKnownEndTime) {
        SearchConditionBuilder taskFilter = VcdClient.Query.getFilterBuilder();
        return taskFilter.is("endDate").notBefore(lastKnownEndTime).and("status").equalTo(TaskStatus.SUCCESS.getLabel(), new String[]{TaskStatus.ERROR.getLabel(), TaskStatus.ABORTED.getLabel()}).wrap().query();
    }

    private XMLGregorianCalendar extractEndDate(QueryResultRecordType task) {
        if (task instanceof QueryResultAdminTaskRecordType) {
            return ((QueryResultAdminTaskRecordType)task).getEndDate();
        }
        if (task instanceof QueryResultTaskRecordType) {
            return ((QueryResultTaskRecordType)task).getEndDate();
        }
        throw new AssertionError((Object)"Returned result objects are not of task/adminTask result types");
    }

    private String extractStatus(QueryResultRecordType task) {
        if (task instanceof QueryResultAdminTaskRecordType) {
            return ((QueryResultAdminTaskRecordType)task).getStatus();
        }
        if (task instanceof QueryResultTaskRecordType) {
            return ((QueryResultTaskRecordType)task).getStatus();
        }
        throw new AssertionError((Object)"Returned result objects are not of task/adminTask result types");
    }

    @Override
    public synchronized void track(TaskType ... tasks) throws IllegalStateException {
        this.track(Stream.of(tasks));
    }

    @Override
    public synchronized void track(Collection<TaskType> tasks) throws IllegalStateException {
        this.track(tasks.stream());
    }

    private void track(Stream<TaskType> tasks) throws IllegalStateException {
        this.validateState();
        tasks.peek(task -> this.taskTimingInfo.updateStartTime(task.getStartTime().toGregorianCalendar().getTime())).collect(Collectors.mapping(IdentifiableResourceType::getId, Collectors.toCollection(() -> this.taskIds)));
    }

    private void validateState() {
        if (this.allTasksAdded.get()) {
            throw new IllegalStateException("Multi task monitor cannot track more tasks");
        }
    }

    @Override
    public Future<Map<String, TaskStatus>> toTrackingFuture() {
        this.allTasksAdded.set(true);
        return this.trackingFuture;
    }
}

