/*
 * Decompiled with CFR 0.152.
 */
package com.wandrell.pattern.repository;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.wandrell.pattern.repository.FilteredRepository;
import java.util.Collection;
import java.util.LinkedList;

public final class CollectionRepository<V>
implements FilteredRepository<V, Predicate<V>> {
    private final Collection<V> data;

    public CollectionRepository() {
        this(new LinkedList());
    }

    public CollectionRepository(Collection<V> collection) {
        Preconditions.checkNotNull(collection, (Object)"Received a null pointer as collection");
        this.data = collection;
    }

    @Override
    public final void add(V entity) {
        this.getData().add(entity);
    }

    @Override
    public final Collection<V> getAll() {
        return new LinkedList<V>(this.getData());
    }

    @Override
    public final Collection<V> getCollection(Predicate<V> filter) {
        LinkedList<V> result = new LinkedList<V>();
        for (V entity : this.getData()) {
            if (!filter.apply(entity)) continue;
            result.add(entity);
        }
        return result;
    }

    @Override
    public final V getEntity(Predicate<V> filter) {
        Collection<V> entities = this.getCollection(filter);
        V entity = entities.isEmpty() ? null : (V)entities.iterator().next();
        return entity;
    }

    @Override
    public final void remove(V entity) {
        this.getData().remove(entity);
    }

    @Override
    public final void update(V entity) {
        if (this.getData().contains(entity)) {
            this.remove(entity);
            this.add(entity);
        }
    }

    private final Collection<V> getData() {
        return this.data;
    }
}

