/*
 * Decompiled with CFR 0.152.
 */
package com.wassonlabs.attack;

import com.wassonlabs.attack.EnterpriseAttack;
import com.wassonlabs.attack.ParsedAttack;
import com.wassonlabs.attack.Subtechnique;
import com.wassonlabs.attack.Tactic;
import com.wassonlabs.attack.Technique;
import java.io.BufferedInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

final class AttackParser {
    private AttackParser() {
    }

    static ParsedAttack parseAttack(String attackSourceFile) {
        Document attackDocument = AttackParser.parseAttackSourceFile(attackSourceFile);
        Element attackElement = attackDocument.getDocumentElement();
        if (!attackElement.getNodeName().equals("attack")) {
            throw new RuntimeException("Unexpected node name: " + attackElement.getNodeName());
        }
        NodeList attackChildren = attackElement.getChildNodes();
        List<Tactic> tactics = null;
        List<Technique> techniques = null;
        List<Subtechnique> subtechniques = null;
        block10: for (int i = 0; i < attackChildren.getLength(); ++i) {
            String attackChildName;
            Node attackChild = attackChildren.item(i);
            switch (attackChildName = attackChild.getNodeName()) {
                case "tactics": {
                    tactics = AttackParser.parseTactics(attackChild);
                    continue block10;
                }
                case "techniques": {
                    techniques = AttackParser.parseTechniques(attackChild);
                    continue block10;
                }
                case "subtechniques": {
                    subtechniques = AttackParser.parseSubtechniques(attackChild);
                    continue block10;
                }
                default: {
                    throw new RuntimeException("Unexpected node name: " + attackChild.getNodeName());
                }
            }
        }
        return new ParsedAttack(tactics, techniques, subtechniques);
    }

    private static List<String> parseReferences(Node referencesNode, String referenceNodeName) {
        ArrayList<String> references = new ArrayList<String>();
        NodeList referencesChildren = referencesNode.getChildNodes();
        for (int i = 0; i < referencesChildren.getLength(); ++i) {
            Node referenceNode = referencesChildren.item(i);
            if (!referenceNode.getNodeName().equals(referenceNodeName)) continue;
            String referenceId = referenceNode.getAttributes().getNamedItem("id").getNodeValue();
            references.add(referenceId);
        }
        return List.copyOf(references);
    }

    private static List<Tactic> parseTactics(Node tacticsNode) {
        ArrayList<Tactic> tactics = new ArrayList<Tactic>();
        NodeList tacticsChildren = tacticsNode.getChildNodes();
        for (int i = 0; i < tacticsChildren.getLength(); ++i) {
            Node tacticNode = tacticsChildren.item(i);
            String tacticNodeName = tacticNode.getNodeName();
            if (!tacticNodeName.equals("tactic")) {
                throw new RuntimeException("Unexpected node name: " + tacticNode.getNodeName());
            }
            String tacticId = tacticNode.getAttributes().getNamedItem("id").getNodeValue();
            String tacticName = tacticNode.getAttributes().getNamedItem("name").getNodeValue();
            String tacticDescription = tacticNode.getAttributes().getNamedItem("description").getNodeValue();
            List<String> techniqueIds = AttackParser.parseReferences(tacticNode, "technique");
            tactics.add(new Tactic(tacticId, tacticName, tacticDescription, techniqueIds));
        }
        return tactics;
    }

    private static List<Technique> parseTechniques(Node techniquesNode) {
        ArrayList<Technique> techniques = new ArrayList<Technique>();
        NodeList techniquesChildren = techniquesNode.getChildNodes();
        for (int i = 0; i < techniquesChildren.getLength(); ++i) {
            Node techniqueNode = techniquesChildren.item(i);
            String techniqueNodeName = techniqueNode.getNodeName();
            if (!techniqueNodeName.equals("technique")) {
                throw new RuntimeException("Unexpected node name: " + techniqueNode.getNodeName());
            }
            String techniqueId = techniqueNode.getAttributes().getNamedItem("id").getNodeValue();
            String techniqueName = techniqueNode.getAttributes().getNamedItem("name").getNodeValue();
            String techniqueDescription = techniqueNode.getAttributes().getNamedItem("description").getNodeValue();
            List<String> subtechniqueIds = AttackParser.parseReferences(techniqueNode, "subtechnique");
            List<String> tacticIds = AttackParser.parseReferences(techniqueNode, "tactic");
            techniques.add(new Technique(techniqueId, techniqueName, techniqueDescription, tacticIds, subtechniqueIds));
        }
        return techniques;
    }

    private static List<Subtechnique> parseSubtechniques(Node subtechniquesNode) {
        ArrayList<Subtechnique> subtechniques = new ArrayList<Subtechnique>();
        NodeList subtechniquesChildren = subtechniquesNode.getChildNodes();
        for (int i = 0; i < subtechniquesChildren.getLength(); ++i) {
            Node subtechniqueNode = subtechniquesChildren.item(i);
            String subtechniqueNodeName = subtechniqueNode.getNodeName();
            if (!subtechniqueNodeName.equals("subtechnique")) {
                throw new RuntimeException("Unexpected node name: " + subtechniqueNode.getNodeName());
            }
            String subtechniqueId = subtechniqueNode.getAttributes().getNamedItem("id").getNodeValue();
            String subtechniqueName = subtechniqueNode.getAttributes().getNamedItem("name").getNodeValue();
            String subtechniqueDescription = subtechniqueNode.getAttributes().getNamedItem("description").getNodeValue();
            String subtechniqueTechnique = subtechniqueNode.getAttributes().getNamedItem("technique").getNodeValue();
            subtechniques.add(new Subtechnique(subtechniqueId, subtechniqueName, subtechniqueDescription, subtechniqueTechnique));
        }
        return subtechniques;
    }

    private static Document parseAttackSourceFile(String attackSourceFile) {
        Document d;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            dbf.setFeature("http://xml.org/sax/features/external-general-entities", false);
            dbf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            dbf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            dbf.setXIncludeAware(false);
            dbf.setExpandEntityReferences(false);
            dbf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException("Failed to apply XML parser hardening.", e);
        }
        try (BufferedInputStream is = new BufferedInputStream(Objects.requireNonNull(EnterpriseAttack.class.getClassLoader().getResourceAsStream(attackSourceFile)));){
            d = dbf.newDocumentBuilder().parse(is);
        }
        catch (Exception e) {
            throw new RuntimeException("Error loading MITRE ATT&CK data.", e);
        }
        return d;
    }
}

