/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.integrations;

import com.wavefront.integrations.AbstractDirectConnectionHandler;
import com.wavefront.integrations.WavefrontSender;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WavefrontDirectSender
extends AbstractDirectConnectionHandler
implements WavefrontSender {
    private static final String DEFAULT_SOURCE = "wavefrontDirectSender";
    private static final Logger LOGGER = LoggerFactory.getLogger(WavefrontDirectSender.class);
    private static final String quote = "\"";
    private static final String escapedQuote = "\\\"";
    private static final int MAX_QUEUE_SIZE = 50000;
    private static final int BATCH_SIZE = 10000;
    private final LinkedBlockingQueue<String> buffer = new LinkedBlockingQueue(50000);
    private final AtomicInteger failures = new AtomicInteger();

    public WavefrontDirectSender(String server, String token) {
        super(server, token);
    }

    @Override
    public void send(String name, double value) throws IOException {
        this.addPoint(name, value, null, DEFAULT_SOURCE, null);
    }

    @Override
    public void send(String name, double value, @Nullable Long timestamp) throws IOException {
        this.addPoint(name, value, timestamp, DEFAULT_SOURCE, null);
    }

    @Override
    public void send(String name, double value, @Nullable Long timestamp, String source) throws IOException {
        this.addPoint(name, value, timestamp, source, null);
    }

    @Override
    public void send(String name, double value, String source, @Nullable Map<String, String> pointTags) throws IOException {
        this.addPoint(name, value, null, source, pointTags);
    }

    @Override
    public void send(String name, double value, @Nullable Long timestamp, String source, @Nullable Map<String, String> pointTags) throws IOException {
        this.addPoint(name, value, timestamp, source, pointTags);
    }

    private void addPoint(@NotNull String name, double value, @Nullable Long timestamp, @NotNull String source, @Nullable Map<String, String> pointTags) throws IOException {
        String point = WavefrontDirectSender.pointToString(name, value, timestamp, source, pointTags);
        if (point != null && !this.buffer.offer(point)) {
            LOGGER.debug("Buffer full, dropping point " + name);
        }
    }

    private static String escapeQuotes(String raw) {
        return StringUtils.replace((String)raw, (String)quote, (String)escapedQuote);
    }

    @Nullable
    static String pointToString(String name, double value, @Nullable Long timestamp, String source, @Nullable Map<String, String> pointTags) {
        if (StringUtils.isBlank((String)name) || StringUtils.isBlank((String)source)) {
            LOGGER.debug("Invalid point: Empty name/source");
            return null;
        }
        StringBuilder sb = new StringBuilder(quote).append(WavefrontDirectSender.escapeQuotes(name)).append(quote).append(" ").append(Double.toString(value)).append(" ");
        if (timestamp != null) {
            sb.append(Long.toString(timestamp)).append(" ");
        }
        sb.append("source=").append(quote).append(WavefrontDirectSender.escapeQuotes(source)).append(quote);
        if (pointTags != null) {
            for (Map.Entry<String, String> entry : pointTags.entrySet()) {
                sb.append(' ').append(quote).append(WavefrontDirectSender.escapeQuotes(entry.getKey())).append(quote).append("=").append(quote).append(WavefrontDirectSender.escapeQuotes(entry.getValue())).append(quote);
            }
        }
        return sb.toString();
    }

    @Override
    protected void internalFlush() throws IOException {
        if (!this.isConnected()) {
            return;
        }
        List<String> points = this.getPointsBatch();
        if (points.isEmpty()) {
            return;
        }
        try (Response response = null;
             InputStream is = this.pointsToStream(points);){
            response = this.report("graphite_v2", is);
            if (response.getStatusInfo().getFamily() == Response.Status.Family.SERVER_ERROR || response.getStatusInfo().getFamily() == Response.Status.Family.CLIENT_ERROR) {
                LOGGER.debug("Error reporting points, respStatus=" + response.getStatus());
                try {
                    this.buffer.addAll(points);
                }
                catch (Exception ex) {
                    LOGGER.debug("Buffer full, dropping attempted points");
                }
            }
        }
    }

    private InputStream pointsToStream(List<String> points) {
        StringBuilder sb = new StringBuilder();
        boolean newLine = false;
        for (String point : points) {
            if (newLine) {
                sb.append("\n");
            }
            sb.append(point);
            newLine = true;
        }
        return new ByteArrayInputStream(sb.toString().getBytes());
    }

    private List<String> getPointsBatch() {
        int blockSize = Math.min(this.buffer.size(), 10000);
        ArrayList<String> points = new ArrayList<String>(blockSize);
        this.buffer.drainTo(points, blockSize);
        return points;
    }

    @Override
    public int getFailureCount() {
        return this.failures.get();
    }

    @Override
    public void run() {
        try {
            this.internalFlush();
        }
        catch (Throwable ex) {
            LOGGER.debug("Unable to report to Wavefront", ex);
        }
    }
}

