/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.ingester;

import com.google.common.base.Preconditions;
import com.wavefront.ingester.AbstractIngesterFormatter;
import com.wavefront.ingester.Decoder;
import com.wavefront.ingester.ReportPointIngesterFormatter;
import java.util.List;
import wavefront.report.ReportPoint;

public class OpenTSDBDecoder
implements Decoder<String> {
    private final String hostName;
    private static final AbstractIngesterFormatter<ReportPoint> FORMAT = ReportPointIngesterFormatter.newBuilder().whiteSpace().appendCaseInsensitiveLiteral("put").whiteSpace().appendMetricName().whiteSpace().appendTimestamp().whiteSpace().appendValue().whiteSpace().appendAnnotationsConsumer().whiteSpace().build();
    private List<String> customSourceTags;

    public OpenTSDBDecoder(List<String> customSourceTags) {
        this.hostName = "unknown";
        Preconditions.checkNotNull(customSourceTags);
        this.customSourceTags = customSourceTags;
    }

    public OpenTSDBDecoder(String hostName, List<String> customSourceTags) {
        Preconditions.checkNotNull((Object)hostName);
        this.hostName = hostName;
        Preconditions.checkNotNull(customSourceTags);
        this.customSourceTags = customSourceTags;
    }

    @Override
    public void decodeReportPoints(String msg, List<ReportPoint> out, String customerId) {
        ReportPoint point = FORMAT.drive(msg, this.hostName, customerId, this.customSourceTags);
        if (out != null) {
            out.add(point);
        }
    }

    @Override
    public void decodeReportPoints(String msg, List<ReportPoint> out) {
        ReportPoint point = FORMAT.drive(msg, this.hostName, "dummy", this.customSourceTags);
        if (out != null) {
            out.add(point);
        }
    }

    public String getDefaultHostName() {
        return this.hostName;
    }
}

