/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.ingester;

import com.google.common.base.Preconditions;
import com.wavefront.ingester.AbstractIngesterFormatter;
import com.wavefront.ingester.ReportableEntityDecoder;
import com.wavefront.ingester.SpanIngesterFormatter;
import java.util.List;
import wavefront.report.Span;

public class SpanDecoder
implements ReportableEntityDecoder<String, Span> {
    private final String hostName;
    private static final AbstractIngesterFormatter<Span> FORMAT = SpanIngesterFormatter.newBuilder().whiteSpace().appendName().whiteSpace().appendBoundedAnnotationsConsumer().whiteSpace().appendRawTimestamp().whiteSpace().appendDuration().whiteSpace().build();

    public SpanDecoder(String hostName) {
        Preconditions.checkNotNull((Object)hostName);
        this.hostName = hostName;
    }

    @Override
    public void decode(String msg, List<Span> out, String customerId) {
        Span span = FORMAT.drive(msg, this.hostName, customerId);
        if (out != null) {
            out.add(span);
        }
    }
}

