/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under the terms of the
 * GNU Lesser General Public License as published by the Free Software Foundation; either version
 * 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
 * even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 */

package com.wedeploy.api.sdk;

import com.wedeploy.api.sdk.realtime.SocketIO;

import java.nio.file.Path;

import java.util.List;

/**
 * Execution context.
 */
public interface Context {

	/**
	 * Returns application configuration.
	 */
	public AppConfig appConfig();

	/**
	 * Returns application shared data map.
	 */
	public SharedData appData();

	/**
	 * Returns assets file from <code>assets</code> folder.
	 */
	public Path assetsFile(String fileName);

	/**
	 * Returns assets files from <code>assets</code> folder that matches
	 * provided glob patterns.
	 */
	public List<Path> assetsFiles(String... glob);

	/**
	 * Returns static files from <code>rootFolder</code> that matches provided
	 * glob pattern.
	 */
	public List<Path> assetsFiles(String rootFolder, String glob);

	/**
	 * Returns context id.
	 */
	public String id();

	/**
	 * Returns the socket io server.
	 */
	public SocketIO io();

	/**
	 * Returns single file from <code>web</code> folder. Returns
	 * <code>null</code> if file does not exist.
	 */
	public Path webFile(String fileName);

	/**
	 * Returns static files from <code>web</code> folder that matches provided
	 * glob patterns.
	 */
	public List<Path> webFiles(String... glob);

	/**
	 * Returns static files from <code>rootFolder</code> that matches provided
	 * glob pattern.
	 */
	public List<Path> webFiles(String rootFolder, String glob);

}