package com.wedeploy.api.sdk;

/**
 * Error 408 errors.
 */
public class Error408<T> extends ErrorBase<T, Error408<T>> {

	public Error408(ErrorData<T> errorData, String message) {
		super(errorData, 408, message, "Request Timeout");
	}

	public Error408<T> requestTimeout() {
		return requestTimeout(null);
	}

	public Error408<T> requestTimeout(String message) {
		return error(
			"requestTimeout", message,
			"The server did not produce a response within the time that the " +
				"server was prepared to wait."
		);
	}
}
