/*
 * Decompiled with CFR 0.152.
 */
package com.wedeploy.api.query;

import com.wedeploy.api.query.Aggregation;
import com.wedeploy.api.query.Embodied;
import com.wedeploy.api.query.Filter;
import com.wedeploy.api.query.Util;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface Query
extends Embodied {
    public static Builder aggregate(Aggregation aggregation) {
        return Query.builder().aggregate(aggregation);
    }

    public static Builder aggregate(String name, String field, String operator) {
        return Query.aggregate(Aggregation.of(name, field, operator));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder count() {
        return Query.builder().count();
    }

    public static Builder fetch() {
        return Query.builder().fetch();
    }

    public static Builder filter(Filter filter) {
        return Query.builder().filter(filter);
    }

    public static Builder filter(String field, Object value) {
        return Query.filter(Filter.field(field, value));
    }

    public static Builder filter(String field, String operator, Object value) {
        return Query.filter(Filter.field(field, operator, value));
    }

    public static Builder highlight(String field) {
        return Query.builder().highlight(field);
    }

    public static Builder limit(int limit) {
        return Query.builder().limit(limit);
    }

    public static Builder offset(int offset) {
        return Query.builder().offset(offset);
    }

    public static Builder search(Filter filter) {
        return Query.builder().search(filter);
    }

    public static Builder search(String text) {
        return Query.search(Filter.match(text));
    }

    public static Builder search(String field, String text) {
        return Query.search(Filter.match(field, text));
    }

    public static Builder search(String field, String operator, Object value) {
        return Query.search(Filter.field(field, operator, value));
    }

    public static Builder sort(String field) {
        return Query.builder().sort(field);
    }

    public static Builder sort(String field, String direction) {
        return Query.builder().sort(field, direction);
    }

    public static Builder type(String type) {
        return Query.builder().type(type);
    }

    public static final class Builder
    implements Query {
        private final List<Aggregation> aggregations = new ArrayList<Aggregation>();
        private final List<Filter> filters = new ArrayList<Filter>();
        private final List<String> highlights = new ArrayList<String>();
        private Integer limit;
        private Integer offset;
        private final List<Filter> queries = new ArrayList<Filter>();
        private final List<Map> sort = new ArrayList<Map>();
        private String type;

        @Override
        public Builder aggregate(Aggregation aggregation) {
            this.aggregations.add(aggregation);
            return this;
        }

        @Override
        public Builder aggregate(String name, String field, String operator) {
            return this.aggregate(Aggregation.of(name, field, operator));
        }

        @Override
        public Map body() {
            HashMap<String, Object> map = new HashMap<String, Object>();
            if (this.type != null) {
                map.put("type", this.type);
            }
            if (!this.filters.isEmpty()) {
                map.put("filter", this.filters);
            }
            if (!this.sort.isEmpty()) {
                map.put("sort", this.sort);
            }
            if (this.limit != null) {
                map.put("limit", this.limit);
            }
            if (this.offset != null) {
                map.put("offset", this.offset);
            }
            if (!this.queries.isEmpty()) {
                map.put("search", this.queries);
            }
            if (!this.highlights.isEmpty()) {
                map.put("highlight", this.highlights);
            }
            if (!this.aggregations.isEmpty()) {
                map.put("aggregation", this.aggregations);
            }
            return map;
        }

        @Override
        public Builder count() {
            return this.type("count");
        }

        @Override
        public Builder fetch() {
            return this.type("fetch");
        }

        @Override
        public Builder filter(Filter filter) {
            this.filters.add(filter);
            return this;
        }

        @Override
        public Builder filter(String field, Object value) {
            return this.filter(Filter.field(field, value));
        }

        @Override
        public Builder filter(String field, String operator, Object value) {
            return this.filter(Filter.field(field, operator, value));
        }

        @Override
        public Builder highlight(String field) {
            this.highlights.add(field);
            return this;
        }

        @Override
        public Builder limit(int limit) {
            this.limit = limit;
            return this;
        }

        @Override
        public Builder offset(int offset) {
            this.offset = offset;
            return this;
        }

        @Override
        public Builder search(Filter filter) {
            this.queries.add(filter);
            return this;
        }

        @Override
        public Builder search(String text) {
            return this.search(Filter.match(text));
        }

        @Override
        public Builder search(String field, String text) {
            return this.search(Filter.match(field, text));
        }

        @Override
        public Builder search(String field, String operator, Object value) {
            return this.search(Filter.field(field, operator, value));
        }

        @Override
        public Builder sort(String field) {
            return this.sort(field, "asc");
        }

        @Override
        public Builder sort(String field, String direction) {
            this.sort.add(Util.wrap(field, direction));
            return this;
        }

        public String toString() {
            return this.bodyAsJson();
        }

        @Override
        public Builder type(String type) {
            this.type = type;
            return this;
        }

        private Builder() {
        }
    }
}

