/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * <p>
 * 1. Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * <p>
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * <p>
 * 3. Neither the name of Liferay, Inc. nor the names of its contributors may
 * be used to endorse or promote products derived from this software without
 * specific prior written permission.
 * <p>
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

package com.wedeploy.api.sdk;

import com.wedeploy.api.sdk.realtime.SocketIO;

import java.nio.file.Path;
import java.util.List;

/**
 * Execution context.
 */
public interface Context {

	/**
	 * Returns application configuration.
	 */
	public AppConfig appConfig();

	/**
	 * Returns application shared data map.
	 */
	public SharedData appData();

	/**
	 * Returns assets file from <code>assets</code> folder.
	 */
	public Path assetsFile(String fileName);

	/**
	 * Returns assets files from <code>assets</code> folder that matches
	 * provided glob patterns.
	 */
	public List<Path> assetsFiles(String... glob);

	/**
	 * Returns static files from <code>rootFolder</code> that matches provided
	 * glob pattern.
	 */
	public List<Path> assetsFiles(String rootFolder, String glob);

	/**
	 * Returns context id.
	 */
	public String id();

	/**
	 * Returns the socket io server.
	 */
	public SocketIO io();

	/**
	 * Returns single file from <code>web</code> folder. Returns
	 * <code>null</code> if file does not exist.
	 */
	public Path webFile(String fileName);

	/**
	 * Returns static files from <code>web</code> folder that matches provided
	 * glob patterns.
	 */
	public List<Path> webFiles(String... glob);

	/**
	 * Returns static files from <code>rootFolder</code> that matches provided
	 * glob pattern.
	 */
	public List<Path> webFiles(String rootFolder, String glob);

}
