/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * <p>
 * 1. Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * <p>
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * <p>
 * 3. Neither the name of Liferay, Inc. nor the names of its contributors may
 * be used to endorse or promote products derived from this software without
 * specific prior written permission.
 * <p>
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

package com.wedeploy.api.sdk;

/**
 * Error 403 errors.
 */
public class Error403<T> extends ErrorBase<T, Error403<T>> {

	public Error403(ErrorData<T> errorData, String message) {
		super(errorData, 403, message, "Forbidden");
	}

	public Error403<T> corsRequestOrigin() {
		return corsRequestOrigin(null);
	}

	public Error403<T> corsRequestOrigin(String message) {
		return error(
			"corsRequestOrigin", message,
			"The CORS request is from an unknown origin.");
	}

	public Error403<T> forbidden() {
		return forbidden(null);
	}

	public Error403<T> forbidden(String message) {
		return error(
			"forbidden", message,
			"The requested operation is forbidden and cannot be completed."
		);
	}

	public Error403<T> limitExceeded() {
		return limitExceeded(null);
	}

	public Error403<T> limitExceeded(String message) {
		return error(
			"limitExceeded", message,
			"The request cannot be completed due to access or rate limitations."
		);
	}

	public Error403<T> quotaExceeded() {
		return quotaExceeded(null);
	}

	public Error403<T> quotaExceeded(String message) {
		return error(
			"quotaExceeded", message,
			"The requested operation requires more resources than the quota" +
				" allows."
		);
	}

	public Error403<T> rateLimitExceeded() {
		return rateLimitExceeded(null);
	}

	public Error403<T> rateLimitExceeded(String message) {
		return error(
			"rateLimitExceeded", message,
			"Too many requests have been sent within a given time span."
		);
	}

	public Error403<T> responseTooLarge() {
		return responseTooLarge(null);
	}

	public Error403<T> responseTooLarge(String message) {
		return error(
			"responseTooLarge", message,
			"The requested resource is too large to return."
		);
	}

	public Error403<T> unknownAuth() {
		return unknownAuth(null);
	}

	public Error403<T> unknownAuth(String message) {
		return error(
			"unknownAuth", message,
			"The API server does not recognize the authorization scheme used" +
				" for the request."
		);
	}

}
