/*
 * Decompiled with CFR 0.152.
 */
package com.wedeploy.api.sdk;

import com.wedeploy.api.sdk.ContentType;
import com.wedeploy.api.sdk.Context;
import com.wedeploy.api.sdk.Cookie;
import com.wedeploy.api.sdk.MultiMap;
import com.wedeploy.api.serializer.Parser;
import com.wedeploy.api.serializer.Serializer;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class Base<R> {
    protected static String BODY_ENCODING = "UTF-8";
    protected Map<String, Cookie> cookies = new HashMap<String, Cookie>();
    protected MultiMap<String> headers = MultiMap.newMultiMap();
    private byte[] body;

    public String body() {
        return this.getBodyAsString();
    }

    public R body(byte[] body) {
        this.setBody(body);
        return (R)this;
    }

    public R body(Object body) {
        this.setBodyObject(body);
        return (R)this;
    }

    public R body(String body) {
        this.setBody(body);
        return (R)this;
    }

    public R body(String body, ContentType contentType) {
        this.contentType(contentType);
        this.body(body);
        return (R)this;
    }

    public byte[] bodyBytes() {
        return this.body;
    }

    public <T> List<T> bodyList(Class<T> componentType) {
        if (this.body == null) {
            return null;
        }
        String contentTypeValue = this.contentType();
        ContentType contentType = null;
        contentType = contentTypeValue == null ? ContentType.TEXT : new ContentType(contentTypeValue);
        return Parser.get(contentType).parseAsList(this.getBodyAsString(), componentType);
    }

    public <K, V> Map<K, V> bodyMap(Class<K> keyType, Class<V> valueType) {
        if (this.body == null) {
            return null;
        }
        String contentTypeValue = this.contentType();
        ContentType contentType = null;
        contentType = contentTypeValue == null ? ContentType.TEXT : new ContentType(contentTypeValue);
        return Parser.get(contentType).parseAsMap(this.getBodyAsString(), keyType, valueType);
    }

    public <T> T bodyValue() {
        if (this.body == null) {
            return null;
        }
        String contentTypeValue = this.contentType();
        ContentType contentType = null;
        contentType = contentTypeValue == null ? ContentType.TEXT : new ContentType(contentTypeValue);
        return Parser.get(contentType).parse(this.getBodyAsString());
    }

    public <T> T bodyValue(Class<T> type) {
        if (this.body == null) {
            return null;
        }
        String contentTypeValue = this.contentType();
        ContentType contentType = null;
        contentType = contentTypeValue == null ? ContentType.TEXT : new ContentType(contentTypeValue);
        return Parser.get(contentType).parse(this.getBodyAsString(), type);
    }

    public String contentType() {
        return this.headers().get("Content-Type");
    }

    public R contentType(ContentType contentType) {
        this.header("Content-Type", contentType.toString());
        return (R)this;
    }

    public Context context() {
        throw new UnsupportedOperationException();
    }

    public R cookie(Cookie cookie) {
        this.cookies.put(cookie.name(), cookie);
        return (R)this;
    }

    public Cookie cookie(String name) {
        return this.cookies().get(name);
    }

    public Map<String, Cookie> cookies() {
        return this.cookies;
    }

    public void end() {
    }

    public String header(String name) {
        return this.headers().get(name);
    }

    public R header(String name, String value) {
        this.headers.set(name, value);
        return (R)this;
    }

    public MultiMap<String> headers() {
        return this.headers;
    }

    public boolean isContentType(ContentType contentType) {
        return contentType.isSame(this.contentType());
    }

    protected String getBodyAsString() {
        if (this.body == null) {
            return null;
        }
        try {
            return new String(this.body, BODY_ENCODING);
        }
        catch (UnsupportedEncodingException uee) {
            return null;
        }
    }

    protected void setBody(byte[] value) {
        this.body = value;
    }

    protected void setBody(String value) {
        if (value == null) {
            this.setBody((byte[])null);
        } else {
            try {
                this.setBody(value.getBytes(BODY_ENCODING));
            }
            catch (UnsupportedEncodingException uee) {
                this.setBody((byte[])null);
            }
        }
    }

    protected R setBodyObject(Object body) {
        if (body == null) {
            this.setBody((byte[])null);
            return (R)this;
        }
        if (body instanceof String) {
            this.setBody((String)body);
            return (R)this;
        }
        String bodyJson = Serializer.get(ContentType.JSON).serialize(body);
        this.contentType(ContentType.JSON);
        this.setBody(bodyJson);
        return (R)this;
    }
}

