/*
 * Decompiled with CFR 0.152.
 */
package com.wedeploy.api.sdk;

import com.wedeploy.api.sdk.ContentType;
import com.wedeploy.api.sdk.Context;
import com.wedeploy.api.sdk.Cookie;
import com.wedeploy.api.sdk.MultiMap;
import com.wedeploy.api.sdk.Request;
import com.wedeploy.api.sdk.Session;
import java.util.List;
import java.util.Map;

public interface Response {
    public String body();

    public Response body(byte[] var1);

    public Response body(Object var1);

    public Response body(String var1);

    public Response body(String var1, ContentType var2);

    public byte[] bodyBytes();

    public <T> List<T> bodyList(Class<T> var1);

    public <K, V> Map<K, V> bodyMap(Class<K> var1, Class<V> var2);

    default public <V> Map<String, V> bodyMap(Class<V> valueType) {
        return this.bodyMap(String.class, valueType);
    }

    public <T> T bodyValue();

    public <T> T bodyValue(Class<T> var1);

    public String contentType();

    public Response contentType(ContentType var1);

    public Context context();

    public Map<String, Cookie> cookies();

    public Response cookie(Cookie var1);

    public Cookie cookie(String var1);

    public void end();

    default public void end(Object body) {
        this.body(body);
        this.end();
    }

    default public void end(String body) {
        this.body(body);
        this.end();
    }

    default public void end(String body, ContentType contentType) {
        this.body(body, contentType);
        this.end();
    }

    public String header(String var1);

    public Response header(String var1, String var2);

    public MultiMap<String> headers();

    public boolean isCommitted();

    public boolean isContentType(ContentType var1);

    public Response pipe(Response var1);

    default public void redirect(String url) {
        this.status(302);
        this.header("Location", url);
        this.end();
    }

    public Request request();

    default public Session session() {
        return this.request().session();
    }

    default public Response status(int statusCode) {
        return this.status(statusCode, Status.defaultMessage(statusCode));
    }

    public Response status(int var1, String var2);

    public int statusCode();

    public String statusMessage();

    default public boolean succeeded() {
        return Status.succeeded(this.statusCode());
    }

    public static final class Status {
        public static final int ACCEPTED = 202;
        public static final int BAD_GATEWAY = 502;
        public static final int BAD_REQUEST = 400;
        public static final int CONFLICT = 409;
        public static final int CREATED = 201;
        public static final int FORBIDDEN = 403;
        public static final int FOUND = 302;
        public static final int GATEWAY_TIMEOUT = 504;
        public static final int GONE = 410;
        public static final int INTERNAL_SERVER_ERROR = 500;
        public static final int METHOD_NOT_ALLOWED = 405;
        public static final int MOVED_PERMANENTLY = 301;
        public static final int MULTIPLE_CHOICES = 300;
        public static final int NO_CONTENT = 204;
        public static final int NON_AUTHORITATIVE_INFORMATION = 203;
        public static final int NOT_ACCEPTABLE = 406;
        public static final int NOT_FOUND = 404;
        public static final int NOT_IMPLEMENTED = 501;
        public static final int NOT_MODIFIED = 304;
        public static final int OK = 200;
        public static final int PARTIAL_CONTENT = 206;
        public static final int PROXY_AUTHENTICATION_REQUIRED = 407;
        public static final int REQUEST_TIMEOUT = 408;
        public static final int RESET_CONTENT = 205;
        public static final int SEE_OTHER = 303;
        public static final int SERVICE_UNAVAILABLE = 503;
        public static final int TEMPORARY_REDIRECT = 307;
        public static final int UNAUTHORIZED = 401;
        public static final int USE_PROXY = 305;

        public static String defaultMessage(int statusCode) {
            switch (statusCode) {
                case 200: {
                    return "OK";
                }
                case 201: {
                    return "Created";
                }
                case 202: {
                    return "Accepted";
                }
                case 203: {
                    return "Non-authoritative information";
                }
                case 204: {
                    return "No content";
                }
                case 205: {
                    return "Reset content";
                }
                case 206: {
                    return "Partial content";
                }
                case 300: {
                    return "Multiple choices";
                }
                case 301: {
                    return "Moved permanently";
                }
                case 302: {
                    return "Found";
                }
                case 303: {
                    return "See other";
                }
                case 304: {
                    return "Not modified";
                }
                case 305: {
                    return "Use proxy";
                }
                case 307: {
                    return "Temporary redirect";
                }
                case 400: {
                    return "Bad request";
                }
                case 401: {
                    return "Unauthorized";
                }
                case 403: {
                    return "Forbidden";
                }
                case 404: {
                    return "Not found";
                }
                case 405: {
                    return "Method not allowed";
                }
                case 406: {
                    return "Not acceptable";
                }
                case 407: {
                    return "Proxy authentication required";
                }
                case 408: {
                    return "Request timeout";
                }
                case 409: {
                    return "Conflict";
                }
                case 410: {
                    return "Gone";
                }
                case 500: {
                    return "Internal server error";
                }
                case 501: {
                    return "Not implemented";
                }
                case 502: {
                    return "Bad gateway";
                }
                case 503: {
                    return "Service unavailable";
                }
                case 504: {
                    return "Gateway timeout";
                }
            }
            return "(" + statusCode + ")";
        }

        public static boolean succeeded(int statusCode) {
            return statusCode >= 200 && statusCode <= 399;
        }

        protected Status() {
        }
    }
}

