/*
 * Decompiled with CFR 0.152.
 */
package com.wirequery.core.masking.impl;

import com.wirequery.core.masking.HeaderMaskDeterminer;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\nB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/wirequery/core/masking/impl/SettingsBasedHeaderMaskDeterminer;", "Lcom/wirequery/core/masking/HeaderMaskDeterminer;", "maskSettings", "Lcom/wirequery/core/masking/impl/SettingsBasedHeaderMaskDeterminer$MaskSettings;", "(Lcom/wirequery/core/masking/impl/SettingsBasedHeaderMaskDeterminer$MaskSettings;)V", "shouldUnmaskRequestHeader", "", "name", "", "shouldUnmaskResponseHeader", "MaskSettings", "wirequery-java-core"})
public final class SettingsBasedHeaderMaskDeterminer
implements HeaderMaskDeterminer {
    @NotNull
    private final MaskSettings maskSettings;

    public SettingsBasedHeaderMaskDeterminer(@NotNull MaskSettings maskSettings) {
        Intrinsics.checkNotNullParameter((Object)maskSettings, (String)"maskSettings");
        this.maskSettings = maskSettings;
    }

    @Override
    public boolean shouldUnmaskRequestHeader(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.maskSettings.getRequestHeaders().contains(name) ^ this.maskSettings.getUnmaskByDefault();
    }

    @Override
    public boolean shouldUnmaskResponseHeader(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.maskSettings.getResponseHeaders().contains(name) ^ this.maskSettings.getUnmaskByDefault();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\u000f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J3\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00032\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0006H\u00d6\u0001R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0017"}, d2={"Lcom/wirequery/core/masking/impl/SettingsBasedHeaderMaskDeterminer$MaskSettings;", "", "unmaskByDefault", "", "requestHeaders", "", "", "responseHeaders", "(ZLjava/util/Set;Ljava/util/Set;)V", "getRequestHeaders", "()Ljava/util/Set;", "getResponseHeaders", "getUnmaskByDefault", "()Z", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "wirequery-java-core"})
    public static final class MaskSettings {
        private final boolean unmaskByDefault;
        @NotNull
        private final Set<String> requestHeaders;
        @NotNull
        private final Set<String> responseHeaders;

        public MaskSettings(boolean unmaskByDefault, @NotNull Set<String> requestHeaders, @NotNull Set<String> responseHeaders) {
            Intrinsics.checkNotNullParameter(requestHeaders, (String)"requestHeaders");
            Intrinsics.checkNotNullParameter(responseHeaders, (String)"responseHeaders");
            this.unmaskByDefault = unmaskByDefault;
            this.requestHeaders = requestHeaders;
            this.responseHeaders = responseHeaders;
        }

        public final boolean getUnmaskByDefault() {
            return this.unmaskByDefault;
        }

        @NotNull
        public final Set<String> getRequestHeaders() {
            return this.requestHeaders;
        }

        @NotNull
        public final Set<String> getResponseHeaders() {
            return this.responseHeaders;
        }

        public final boolean component1() {
            return this.unmaskByDefault;
        }

        @NotNull
        public final Set<String> component2() {
            return this.requestHeaders;
        }

        @NotNull
        public final Set<String> component3() {
            return this.responseHeaders;
        }

        @NotNull
        public final MaskSettings copy(boolean unmaskByDefault, @NotNull Set<String> requestHeaders, @NotNull Set<String> responseHeaders) {
            Intrinsics.checkNotNullParameter(requestHeaders, (String)"requestHeaders");
            Intrinsics.checkNotNullParameter(responseHeaders, (String)"responseHeaders");
            return new MaskSettings(unmaskByDefault, requestHeaders, responseHeaders);
        }

        public static /* synthetic */ MaskSettings copy$default(MaskSettings maskSettings, boolean bl, Set set, Set set2, int n, Object object) {
            if ((n & 1) != 0) {
                bl = maskSettings.unmaskByDefault;
            }
            if ((n & 2) != 0) {
                set = maskSettings.requestHeaders;
            }
            if ((n & 4) != 0) {
                set2 = maskSettings.responseHeaders;
            }
            return maskSettings.copy(bl, set, set2);
        }

        @NotNull
        public String toString() {
            return "MaskSettings(unmaskByDefault=" + this.unmaskByDefault + ", requestHeaders=" + this.requestHeaders + ", responseHeaders=" + this.responseHeaders + ")";
        }

        public int hashCode() {
            int n = this.unmaskByDefault ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            int result = n;
            result = result * 31 + ((Object)this.requestHeaders).hashCode();
            result = result * 31 + ((Object)this.responseHeaders).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MaskSettings)) {
                return false;
            }
            MaskSettings maskSettings = (MaskSettings)other;
            if (this.unmaskByDefault != maskSettings.unmaskByDefault) {
                return false;
            }
            if (!Intrinsics.areEqual(this.requestHeaders, maskSettings.requestHeaders)) {
                return false;
            }
            return Intrinsics.areEqual(this.responseHeaders, maskSettings.responseHeaders);
        }
    }
}

