/*
 * Decompiled with CFR 0.152.
 */
package com.yoti.api.client.spi.remote;

import com.yoti.api.client.ActivityDetails;
import com.yoti.api.client.ApplicationProfile;
import com.yoti.api.client.HumanProfile;
import com.yoti.api.client.Profile;
import com.yoti.api.client.spi.remote.ApplicationProfileAdapter;
import com.yoti.api.client.spi.remote.HumanProfileAdapter;
import java.util.Date;
import org.bouncycastle.util.encoders.Base64;

final class SimpleActivityDetails
implements ActivityDetails {
    private final String userId;
    private final ApplicationProfile applicationProfile;
    private final HumanProfile userProfile;
    private final Date timestamp;
    private final String receiptId;

    public SimpleActivityDetails(String userId, Profile userProfile, Profile applicationProfile, Date timestamp, byte[] receiptId) {
        this.userId = this.notNull(userId, "User id");
        this.userProfile = HumanProfileAdapter.wrap(this.notNull(userProfile, "User profile"));
        this.applicationProfile = ApplicationProfileAdapter.wrap(this.notNull(applicationProfile, "Application profile"));
        this.timestamp = this.notNull(timestamp, "Timestamp");
        this.receiptId = Base64.toBase64String((byte[])this.notNull(receiptId, "Receipt id"));
    }

    public HumanProfile getUserProfile() {
        return this.userProfile;
    }

    public ApplicationProfile getApplicationProfile() {
        return this.applicationProfile;
    }

    public String getUserId() {
        return this.userId;
    }

    public Date getTimestamp() {
        return new Date(this.timestamp.getTime());
    }

    public String getReceiptId() {
        return this.receiptId;
    }

    private <T> T notNull(T value, String name) {
        if (value == null) {
            throw new IllegalArgumentException(String.valueOf(name) + " is null");
        }
        return value;
    }
}

