/*
 * Decompiled with CFR 0.152.
 */
package com.yoti.api.client.spi.remote.call;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import org.bouncycastle.util.encoders.Base64;

@JsonIgnoreProperties(ignoreUnknown=true)
public final class Receipt {
    @JsonProperty(value="receipt_id")
    private byte[] receiptId;
    @JsonProperty(value="other_party_profile_content")
    private byte[] otherPartyProfile;
    @JsonProperty(value="profile_content")
    private byte[] profile;
    @JsonProperty(value="other_party_extra_data_content")
    private byte[] otherPartyExtraData;
    @JsonProperty(value="extra_data_content")
    private byte[] extraData;
    @JsonProperty(value="wrapped_receipt_key")
    private byte[] wrappedReceiptKey;
    @JsonProperty(value="policy_uri")
    private String policyUri;
    @JsonProperty(value="personal_key")
    private byte[] personalKey;
    @JsonProperty(value="remember_me_id")
    private byte[] rememberMeId;
    @JsonProperty(value="sharing_outcome")
    private Outcome outcome;
    @JsonProperty(value="timestamp")
    private String timestamp;

    public byte[] getReceiptId() {
        return this.receiptId;
    }

    public byte[] getOtherPartyProfile() {
        return this.otherPartyProfile;
    }

    public byte[] getProfile() {
        return this.profile;
    }

    public byte[] getOtherPartyExtraData() {
        return this.otherPartyExtraData;
    }

    public byte[] getExtraData() {
        return this.extraData;
    }

    public byte[] getWrappedReceiptKey() {
        return this.wrappedReceiptKey;
    }

    public String getPolicyUri() {
        return this.policyUri;
    }

    public byte[] getPersonalKey() {
        return this.personalKey;
    }

    public Outcome getOutcome() {
        return this.outcome;
    }

    public byte[] getRememberMeId() {
        return this.rememberMeId;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.extraData);
        result = 31 * result + Arrays.hashCode(this.otherPartyExtraData);
        result = 31 * result + Arrays.hashCode(this.otherPartyProfile);
        result = 31 * result + (this.outcome == null ? 0 : this.outcome.hashCode());
        result = 31 * result + Arrays.hashCode(this.personalKey);
        result = 31 * result + (this.policyUri == null ? 0 : this.policyUri.hashCode());
        result = 31 * result + Arrays.hashCode(this.profile);
        result = 31 * result + Arrays.hashCode(this.receiptId);
        result = 31 * result + Arrays.hashCode(this.rememberMeId);
        result = 31 * result + (this.timestamp == null ? 0 : this.timestamp.hashCode());
        result = 31 * result + Arrays.hashCode(this.wrappedReceiptKey);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Receipt other = (Receipt)obj;
        if (!Arrays.equals(this.extraData, other.extraData)) {
            return false;
        }
        if (!Arrays.equals(this.otherPartyExtraData, other.otherPartyExtraData)) {
            return false;
        }
        if (!Arrays.equals(this.otherPartyProfile, other.otherPartyProfile)) {
            return false;
        }
        if (this.outcome != other.outcome) {
            return false;
        }
        if (!Arrays.equals(this.personalKey, other.personalKey)) {
            return false;
        }
        if (this.policyUri == null ? other.policyUri != null : !this.policyUri.equals(other.policyUri)) {
            return false;
        }
        if (!Arrays.equals(this.profile, other.profile)) {
            return false;
        }
        if (!Arrays.equals(this.receiptId, other.receiptId)) {
            return false;
        }
        if (!Arrays.equals(this.rememberMeId, other.rememberMeId)) {
            return false;
        }
        if (this.timestamp == null ? other.timestamp != null : !this.timestamp.equals(other.timestamp)) {
            return false;
        }
        return Arrays.equals(this.wrappedReceiptKey, other.wrappedReceiptKey);
    }

    public String toString() {
        return "Receipt [receiptId=" + this.getDisplayReceiptId() + ", otherPartyProfile=" + Arrays.toString(this.otherPartyProfile) + ", profile=" + Arrays.toString(this.profile) + ", otherPartyExtraData=" + Arrays.toString(this.otherPartyExtraData) + ", extraData=" + Arrays.toString(this.extraData) + ", wrappedReceiptKey=" + Arrays.toString(this.wrappedReceiptKey) + ", policyUri=" + this.policyUri + ", personalKey=" + Arrays.toString(this.personalKey) + ", rememberMeId=" + Arrays.toString(this.rememberMeId) + ", outcome=" + (Object)((Object)this.outcome) + ", timestamp=" + this.timestamp + "]";
    }

    public String getDisplayReceiptId() {
        return this.receiptId != null ? Base64.toBase64String((byte[])this.receiptId) : "<>";
    }

    public static final class Builder {
        private final Receipt receipt = new Receipt();

        public Builder withWrappedReceiptKey(byte[] wrappedReceiptKey) {
            this.receipt.wrappedReceiptKey = wrappedReceiptKey;
            return this;
        }

        public Builder withProfile(byte[] profileData) {
            this.receipt.profile = profileData;
            return this;
        }

        public Builder withReceiptId(byte[] receiptId) {
            this.receipt.receiptId = receiptId;
            return this;
        }

        public Builder withOtherPartyProfile(byte[] otherPartyProfile) {
            this.receipt.otherPartyProfile = otherPartyProfile;
            return this;
        }

        public Builder withOtherPartyExtraData(byte[] otherPartyExtraData) {
            this.receipt.otherPartyExtraData = otherPartyExtraData;
            return this;
        }

        public Builder withExtraData(byte[] extraData) {
            this.receipt.extraData = extraData;
            return this;
        }

        public Builder withPolicyUri(String policyUri) {
            this.receipt.policyUri = policyUri;
            return this;
        }

        public Builder withPersonalKey(byte[] personalKey) {
            this.receipt.personalKey = personalKey;
            return this;
        }

        public Builder withOutcome(Outcome outcome) {
            this.receipt.outcome = outcome;
            return this;
        }

        public Builder withRememberMeId(byte[] rememberMeId) {
            this.receipt.rememberMeId = rememberMeId;
            return this;
        }

        public Builder withTimestamp(String timestamp) {
            this.receipt.timestamp = timestamp;
            return this;
        }

        public Receipt build() {
            return this.receipt;
        }
    }

    public static enum Outcome {
        SUCCESS(true),
        FAILURE(false);

        private final boolean successful;

        private Outcome(boolean successful) {
            this.successful = successful;
        }

        public boolean isSuccessful() {
            return this.successful;
        }
    }
}

