/*
 * Decompiled with CFR 0.152.
 */
package com.yoti.api.client.spi.remote;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.yoti.api.client.ActivityDetails;
import com.yoti.api.client.ActivityFailureException;
import com.yoti.api.client.InitialisationException;
import com.yoti.api.client.KeyPairSource;
import com.yoti.api.client.Profile;
import com.yoti.api.client.ProfileException;
import com.yoti.api.client.YotiClient;
import com.yoti.api.client.spi.remote.Base64;
import com.yoti.api.client.spi.remote.DateAttributeValue;
import com.yoti.api.client.spi.remote.JpegAttributeValue;
import com.yoti.api.client.spi.remote.PngAttributeValue;
import com.yoti.api.client.spi.remote.SimpleActivityDetails;
import com.yoti.api.client.spi.remote.SimpleProfile;
import com.yoti.api.client.spi.remote.call.ProfileService;
import com.yoti.api.client.spi.remote.call.Receipt;
import com.yoti.api.client.spi.remote.proto.AttrProto;
import com.yoti.api.client.spi.remote.proto.AttributeListProto;
import com.yoti.api.client.spi.remote.proto.ContentTypeProto;
import com.yoti.api.client.spi.remote.proto.EncryptedDataProto;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMException;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SecureYotiClient
implements YotiClient {
    private static final Logger LOG = LoggerFactory.getLogger(SecureYotiClient.class);
    private static final String SYMMETRIC_CIPHER = "AES/CBC/PKCS7Padding";
    private static final String ASYMMETRIC_CIPHER = "RSA/NONE/PKCS1Padding";
    private static final String STRING_ENCODING = "UTF-8";
    private static final String RFC3339_PATTERN = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    private final String appId;
    private final KeyPair keyPair;
    private final ProfileService profileService;

    SecureYotiClient(String applicationId, KeyPairSource kpSource, ProfileService profileService) throws InitialisationException {
        this.appId = this.notNull(applicationId, "Application id");
        this.keyPair = this.loadKeyPair(this.notNull(kpSource, "Key pair source"));
        this.profileService = this.notNull(profileService, "Profile service");
    }

    public ActivityDetails getActivityDetails(String encryptedConnectToken) throws ProfileException {
        Receipt receipt = this.getReceipt(encryptedConnectToken, this.keyPair);
        return this.buildReceipt(receipt, this.keyPair.getPrivate());
    }

    private Receipt getReceipt(String encryptedConnectToken, KeyPair keyPair) throws ProfileException {
        LOG.debug("Decrypting connect token: {}", (Object)encryptedConnectToken);
        String connectToken = this.decryptConnectToken(encryptedConnectToken, keyPair.getPrivate());
        LOG.debug("Connect token decrypted: {}", (Object)connectToken);
        Receipt receipt = this.profileService.getReceipt(keyPair, this.appId, connectToken);
        if (receipt == null) {
            throw new ProfileException("No receipt for " + connectToken + " was found");
        }
        return receipt;
    }

    private KeyPair loadKeyPair(KeyPairSource kpSource) throws InitialisationException {
        try {
            LOG.debug("Loading key pair from " + kpSource);
            return kpSource.getFromStream((KeyPairSource.StreamVisitor)new KeyStreamVisitor());
        }
        catch (IOException e) {
            throw new InitialisationException("Cannot load key pair", (Throwable)e);
        }
    }

    private String decryptConnectToken(String encryptedConnectToken, PrivateKey privateKey) throws ProfileException {
        String connectToken = null;
        try {
            byte[] byteValue = Base64.getUrlDecoder().decode(encryptedConnectToken);
            byte[] decryptedToken = this.decrypt(byteValue, privateKey);
            connectToken = new String(decryptedToken, STRING_ENCODING);
        }
        catch (Exception e) {
            throw new ProfileException("Cannot decrypt connect token", (Throwable)e);
        }
        return connectToken;
    }

    private ActivityDetails buildReceipt(Receipt receipt, PrivateKey privateKey) throws ProfileException {
        this.validateReceipt(receipt);
        Key secretKey = this.parseKey(this.decrypt(receipt.getWrappedReceiptKey(), privateKey));
        Profile userProfile = this.createProfile(receipt.getOtherPartyProfile(), secretKey);
        Profile applicationProfile = this.createProfile(receipt.getProfile(), secretKey);
        return this.createActivityDetails(userProfile, applicationProfile, receipt);
    }

    private void validateReceipt(Receipt receipt) throws ActivityFailureException {
        if (receipt.getOutcome() == null || !receipt.getOutcome().isSuccessful()) {
            throw new ActivityFailureException("Sharing activity uncuccessful for " + receipt.getDisplayReceiptId());
        }
    }

    private Profile createProfile(byte[] profileBytes, Key secretKey) throws ProfileException {
        Map<String, Object> attributeMap = new HashMap<String, Object>();
        if (profileBytes != null && profileBytes.length > 0) {
            EncryptedDataProto.EncryptedData encryptedData = this.parseProfileContent(profileBytes);
            byte[] profileData = this.decrypt(encryptedData.getCipherText(), secretKey, encryptedData.getIv());
            attributeMap = this.parseProfile(profileData);
        }
        return this.createProfile(attributeMap);
    }

    private EncryptedDataProto.EncryptedData parseProfileContent(byte[] profileContent) throws ProfileException {
        try {
            return EncryptedDataProto.EncryptedData.parseFrom(profileContent);
        }
        catch (InvalidProtocolBufferException e) {
            throw new ProfileException("Cannot decode profile", (Throwable)e);
        }
    }

    private Key parseKey(byte[] keyVal) {
        return new SecretKeySpec(keyVal, SYMMETRIC_CIPHER);
    }

    private Map<String, Object> parseProfile(byte[] profileData) throws ProfileException {
        Map<String, Object> attributeMap = null;
        try {
            AttributeListProto.AttributeList message = AttributeListProto.AttributeList.parseFrom(profileData);
            attributeMap = this.mapAttributes(message);
            LOG.debug("{} attribute(s) parsed", (Object)attributeMap.size());
        }
        catch (InvalidProtocolBufferException e) {
            throw new ProfileException("Cannot parse profile data", (Throwable)e);
        }
        return attributeMap;
    }

    private Map<String, Object> mapAttributes(AttributeListProto.AttributeList message) {
        HashMap<String, Object> attributeMap = new HashMap<String, Object>();
        for (AttrProto.Attribute attribute : message.getAttributesList()) {
            try {
                Object attributeValue = this.mapAttribute(attribute);
                if (attributeValue == null) continue;
                attributeMap.put(attribute.getName(), attributeValue);
            }
            catch (UnsupportedEncodingException e) {
                LOG.info("Cannot decode value for attribute {}", (Object)attribute.getName());
            }
            catch (ParseException e) {
                LOG.info("Cannot parse value for attribute {}", (Object)attribute.getName());
            }
        }
        return attributeMap;
    }

    private Object mapAttribute(AttrProto.Attribute attribute) throws UnsupportedEncodingException, ParseException {
        Object attributeValue = null;
        if (ContentTypeProto.ContentType.STRING.equals((Object)attribute.getContentType())) {
            attributeValue = attribute.getValue().toString(STRING_ENCODING);
        } else if (ContentTypeProto.ContentType.DATE.equals((Object)attribute.getContentType())) {
            attributeValue = DateAttributeValue.parseFrom(attribute.getValue().toByteArray());
        } else if (ContentTypeProto.ContentType.JPEG.equals((Object)attribute.getContentType())) {
            attributeValue = new JpegAttributeValue(attribute.getValue().toByteArray());
        } else if (ContentTypeProto.ContentType.PNG.equals((Object)attribute.getContentType())) {
            attributeValue = new PngAttributeValue(attribute.getValue().toByteArray());
        } else {
            LOG.error("Unknown type {} for attribute {}", (Object)attribute.getContentType(), (Object)attribute.getName());
        }
        return attributeValue;
    }

    private Profile createProfile(Map<String, Object> attributeMap) {
        return new SimpleProfile(attributeMap);
    }

    private ActivityDetails createActivityDetails(Profile userProfile, Profile applicationProfile, Receipt receipt) throws ProfileException {
        try {
            byte[] rmi = receipt.getRememberMeId();
            String rememberMeId = rmi == null ? null : new String(Base64.getEncoder().encode(rmi), STRING_ENCODING);
            SimpleDateFormat format = new SimpleDateFormat(RFC3339_PATTERN);
            Date timestamp = format.parse(receipt.getTimestamp());
            return new SimpleActivityDetails(rememberMeId, userProfile, applicationProfile, timestamp, receipt.getReceiptId());
        }
        catch (UnsupportedEncodingException e) {
            throw new ProfileException("Cannot parse user ID", (Throwable)e);
        }
        catch (ParseException e) {
            throw new ProfileException("Cannot parse timestamp", (Throwable)e);
        }
    }

    private byte[] decrypt(ByteString source, Key key, ByteString initVector) throws ProfileException {
        if (initVector == null) {
            throw new ProfileException("Receipt key IV must not be null.");
        }
        byte[] result = null;
        try {
            Cipher cipher = Cipher.getInstance(SYMMETRIC_CIPHER);
            cipher.init(2, key, new IvParameterSpec(initVector.toByteArray()));
            result = cipher.doFinal(source.toByteArray());
        }
        catch (GeneralSecurityException gse) {
            throw new ProfileException("Error decrypting data", (Throwable)gse);
        }
        catch (IllegalArgumentException iae) {
            throw new ProfileException("Base64 encoding error", (Throwable)iae);
        }
        return result;
    }

    private byte[] decrypt(byte[] source, PrivateKey key) throws ProfileException {
        byte[] result = null;
        try {
            Cipher cipher = Cipher.getInstance(ASYMMETRIC_CIPHER);
            cipher.init(2, key);
            result = cipher.doFinal(source);
        }
        catch (GeneralSecurityException gse) {
            throw new ProfileException("Error decrypting data", (Throwable)gse);
        }
        catch (IllegalArgumentException iae) {
            throw new ProfileException("Base64 encoding error", (Throwable)iae);
        }
        return result;
    }

    private <T> T notNull(T value, String item) {
        if (value == null) {
            throw new IllegalArgumentException(item + " must not be null.");
        }
        return value;
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }

    private static class KeyStreamVisitor
    implements KeyPairSource.StreamVisitor {
        private KeyStreamVisitor() {
        }

        public KeyPair accept(InputStream stream) throws IOException, InitialisationException {
            PEMParser reader = new PEMParser((Reader)new BufferedReader(new InputStreamReader(stream, SecureYotiClient.STRING_ENCODING)));
            KeyPair keyPair = this.findKeyPair(reader);
            if (keyPair == null) {
                throw new InitialisationException("No key pair found in the provided source");
            }
            return keyPair;
        }

        private KeyPair findKeyPair(PEMParser reader) throws IOException, PEMException {
            KeyPair keyPair = null;
            Object o = null;
            while ((o = reader.readObject()) != null) {
                if (!(o instanceof PEMKeyPair)) continue;
                keyPair = new JcaPEMKeyConverter().getKeyPair((PEMKeyPair)o);
                break;
            }
            return keyPair;
        }
    }
}

