/*
 * Decompiled with CFR 0.152.
 */
package com.yoti.api.client.spi.remote.call;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;

public class UrlConnector {
    private static final String DEFAULT_YOTI_CONNECT_TIMEOUT = "0";
    private static final String DEFAULT_YOTI_READ_TIMEOUT = "0";
    private static final String PROPERTY_YOTI_CONNECT_TIMEOUT = "yoti.client.connect.timeout.ms";
    private static final String PROPERTY_YOTI_READ_TIMEOUT = "yoti.client.read.timeout.ms";
    private final String urlString;
    private final int connectTimeout;
    private final int readTimeout;

    private UrlConnector(String urlString) {
        this.urlString = urlString;
        this.connectTimeout = this.getPropertyOrDefaultAsInt(PROPERTY_YOTI_CONNECT_TIMEOUT, "0");
        this.readTimeout = this.getPropertyOrDefaultAsInt(PROPERTY_YOTI_READ_TIMEOUT, "0");
    }

    public static UrlConnector get(String urlString) {
        return new UrlConnector(urlString);
    }

    public HttpURLConnection getHttpUrlConnection() throws IOException {
        HttpURLConnection connection = (HttpURLConnection)new URL(this.urlString).openConnection();
        this.configureTimeouts(connection);
        return connection;
    }

    String getUrlString() {
        return this.urlString;
    }

    private void configureTimeouts(HttpURLConnection connection) {
        connection.setConnectTimeout(this.connectTimeout);
        connection.setReadTimeout(this.readTimeout);
    }

    private int getPropertyOrDefaultAsInt(String propertyKey, String defaultValue) {
        String value = System.getProperty(propertyKey, defaultValue);
        return Integer.parseInt(value);
    }
}

