/*
 * Decompiled with CFR 0.152.
 */
package com.zx5435.mathjava;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.zx5435.mathjava.MyScope;
import com.zx5435.mathjava.node.BaseMathNode;
import com.zx5435.mathjava.node.MathNode;
import java.util.List;
import java.util.Map;

public class Mathjs {
    private MathNode node;

    public static Mathjs compileString(String logic) {
        Mathjs mjs = new Mathjs();
        JsonObject o = (JsonObject)new Gson().fromJson(logic, JsonObject.class);
        mjs.node = BaseMathNode.load(o, new MyScope());
        return mjs;
    }

    public Double evaluate() {
        return this.evaluate(null);
    }

    public Double evaluate(Map<String, Double> scope) {
        if (scope != null) {
            this.node.setScope(scope);
        }
        Double val = this.node.genVal();
        System.out.printf("======= %s = %s\n", this.node.genStr(), val);
        return val;
    }

    public List<Double> evaluateByExpr(int start, int end, int step) {
        MyScope scope = this.node.getScope();
        scope.start = start;
        scope.end = end;
        scope.step = step;
        scope.size = (end - start) / step;
        List<Double> val = this.node.genExpr();
        System.out.printf("======= %s = %s\n", this.node.genStr(), val);
        return val;
    }
}

