/*
 * Decompiled with CFR 0.152.
 */
package com.zx5435.mathjava.node;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.zx5435.mathjava.MyScope;
import com.zx5435.mathjava.node.BaseMathNode;
import com.zx5435.mathjava.node.MathNode;
import com.zx5435.mathjava.node.function.MyMath;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class FunctionNode
extends BaseMathNode
implements MathNode {
    public MathNode fn;
    public List<MathNode> args = new ArrayList<MathNode>();

    public FunctionNode(JsonObject raw, MyScope scope) {
        super(raw, scope);
        this.fn = FunctionNode.load(raw.get("fn").getAsJsonObject(), this.getScope());
        JsonArray args = raw.get("args").getAsJsonArray();
        for (JsonElement arg : args) {
            this.args.add(FunctionNode.load(arg.getAsJsonObject(), this.getScope()));
        }
    }

    @Override
    public String genStr() {
        ArrayList<String> arr = new ArrayList<String>();
        for (MathNode arg : this.args) {
            arr.add(arg.genStr());
        }
        return this.fn.genStr() + "(" + String.join((CharSequence)", ", arr) + ")";
    }

    @Override
    public Double genVal() {
        try {
            return MyMath.runFn(this.fn.genStr(), this.args);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            return null;
        }
    }

    @Override
    public List<Double> genExpr() {
        ArrayList<List<Double>> argArr = new ArrayList<List<Double>>();
        for (MathNode arg : this.args) {
            argArr.add(arg.genExpr());
        }
        List<Object> c = new ArrayList<Object>(Collections.nCopies(this.getScope().size, null));
        try {
            c = MyMath.runFnExpr(this.fn.genStr(), argArr);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        return c;
    }
}

