/*
 * Decompiled with CFR 0.152.
 */
package com.zx5435.mathjava.node;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.zx5435.mathjava.MyScope;
import com.zx5435.mathjava.node.BaseMathNode;
import com.zx5435.mathjava.node.MathNode;
import com.zx5435.mathjava.node.function.MyMath;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class OperatorNode
extends BaseMathNode
implements MathNode {
    public String fn;
    public String op;
    public ArrayList<MathNode> args = new ArrayList();
    public boolean implicit;

    public OperatorNode(JsonObject raw, MyScope scope) {
        super(raw, scope);
        this.fn = raw.get("fn").getAsString();
        this.op = raw.get("op").getAsString();
        this.implicit = raw.get("implicit").getAsBoolean();
        JsonArray args = raw.get("args").getAsJsonArray();
        for (JsonElement arg : args) {
            this.args.add(OperatorNode.load(arg.getAsJsonObject(), this.getScope()));
        }
    }

    @Override
    public String genStr() {
        String a = this.args.get(0).genStr();
        String b = this.args.get(1).genStr();
        return a + " " + this.op + " " + b;
    }

    @Override
    public Double genVal() {
        Double a = this.args.get(0).genVal();
        Double b = this.args.get(1).genVal();
        if (a == null || b == null) {
            return null;
        }
        try {
            return MyMath.runTwo(this.fn, a, b);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            return null;
        }
    }

    @Override
    public List<Double> genExpr() {
        List<Double> a = this.args.get(0).genExpr();
        List<Double> b = this.args.get(1).genExpr();
        if (a == null || b == null || a.size() != b.size()) {
            return null;
        }
        ArrayList<Object> c = new ArrayList<Object>(Collections.nCopies(this.getScope().size, null));
        try {
            for (int i = 0; i < c.size(); ++i) {
                c.set(i, MyMath.runTwo(this.fn, a.get(i), b.get(i)));
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        return c;
    }
}

