/*
 * Decompiled with CFR 0.152.
 */
package com.zx5435.mathjava.node.function;

import com.zx5435.mathjava.node.MathNode;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class MyMath {
    private static final Map<String, Function<List<MathNode>, Double>> FN_MAP = new HashMap<String, Function<List<MathNode>, Double>>();
    private static final Map<String, Function<List<List<Double>>, List<Double>>> FN_MAP_EXPR = new HashMap<String, Function<List<List<Double>>, List<Double>>>();

    public static Double runFn(String fn, List<MathNode> args) throws Exception {
        Function<List<MathNode>, Double> func = FN_MAP.get(fn);
        if (func == null) {
            throw new Exception("no fn: " + fn);
        }
        return func.apply(args);
    }

    public static List<Double> runFnExpr(String fn, List<List<Double>> args) throws Exception {
        Function<List<List<Double>>, List<Double>> func = FN_MAP_EXPR.get(fn);
        if (func == null) {
            throw new Exception("no fn: " + fn);
        }
        return func.apply(args);
    }

    public static void loadExtFunc(Map<String, Function<List<MathNode>, Double>> fnMap) {
        for (Map.Entry<String, Function<List<MathNode>, Double>> one : fnMap.entrySet()) {
            FN_MAP.put(one.getKey(), one.getValue());
        }
    }

    public static double runTwo(String fn, double a, double b) throws Exception {
        switch (fn) {
            case "add": {
                return MyMath.add(a, b);
            }
            case "subtract": {
                return MyMath.subtract(a, b);
            }
            case "multiply": {
                return MyMath.multiply(a, b);
            }
            case "divide": {
                return MyMath.divide(a, b);
            }
        }
        throw new Exception("no fn: " + fn);
    }

    public static double add(double v1, double v2) {
        BigDecimal b1 = BigDecimal.valueOf(v1);
        BigDecimal b2 = BigDecimal.valueOf(v2);
        return b1.add(b2).doubleValue();
    }

    public static double subtract(double v1, double v2) {
        BigDecimal b1 = BigDecimal.valueOf(v1);
        BigDecimal b2 = BigDecimal.valueOf(v2);
        return b1.subtract(b2).doubleValue();
    }

    public static double multiply(double v1, double v2) {
        BigDecimal b1 = BigDecimal.valueOf(v1);
        BigDecimal b2 = BigDecimal.valueOf(v2);
        return b1.multiply(b2).doubleValue();
    }

    public static double divide(double v1, double v2) {
        BigDecimal b1 = BigDecimal.valueOf(v1);
        BigDecimal b2 = BigDecimal.valueOf(v2);
        return b1.divide(b2, RoundingMode.UP).doubleValue();
    }

    static {
        FN_MAP.put("sin", list -> Math.sin(((MathNode)list.get(0)).genVal()));
        FN_MAP.put("cos", list -> Math.cos(((MathNode)list.get(0)).genVal()));
        FN_MAP_EXPR.put("sin", list -> {
            List doubles = (List)list.get(0);
            for (int i = 0; i < doubles.size(); ++i) {
                doubles.set(i, Math.sin((Double)doubles.get(i)));
            }
            return doubles;
        });
    }
}

