/*
 * Decompiled with CFR 0.152.
 */
package de.aaschmid.taskwarrior.message;

import de.aaschmid.taskwarrior.message.TaskwarriorAuthentication;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="TaskwarriorAuthentication", generator="Immutables")
@SuppressFBWarnings
@NotThreadSafe
final class TaskwarriorAuthenticationBuilder {
    private static final long INIT_BIT_AUTH_KEY = 1L;
    private static final long INIT_BIT_ORGANIZATION = 2L;
    private static final long INIT_BIT_USER = 4L;
    private long initBits = 7L;
    @Nullable
    private UUID authKey;
    @Nullable
    private String organization;
    @Nullable
    private String user;

    TaskwarriorAuthenticationBuilder() {
    }

    public final TaskwarriorAuthenticationBuilder from(TaskwarriorAuthentication instance) {
        Objects.requireNonNull(instance, "instance");
        this.authKey(instance.getAuthKey());
        this.organization(instance.getOrganization());
        this.user(instance.getUser());
        return this;
    }

    public final TaskwarriorAuthenticationBuilder authKey(UUID authKey) {
        this.authKey = Objects.requireNonNull(authKey, "authKey");
        this.initBits &= 0xFFFFFFFFFFFFFFFEL;
        return this;
    }

    public final TaskwarriorAuthenticationBuilder organization(String organization) {
        this.organization = Objects.requireNonNull(organization, "organization");
        this.initBits &= 0xFFFFFFFFFFFFFFFDL;
        return this;
    }

    public final TaskwarriorAuthenticationBuilder user(String user) {
        this.user = Objects.requireNonNull(user, "user");
        this.initBits &= 0xFFFFFFFFFFFFFFFBL;
        return this;
    }

    public TaskwarriorAuthentication build() {
        if (this.initBits != 0L) {
            throw new IllegalStateException(this.formatRequiredAttributesMessage());
        }
        return new ImmutableTaskwarriorAuthentication(this);
    }

    private String formatRequiredAttributesMessage() {
        ArrayList<String> attributes = new ArrayList<String>();
        if ((this.initBits & 1L) != 0L) {
            attributes.add("authKey");
        }
        if ((this.initBits & 2L) != 0L) {
            attributes.add("organization");
        }
        if ((this.initBits & 4L) != 0L) {
            attributes.add("user");
        }
        return "Cannot build TaskwarriorAuthentication, some of required attributes are not set " + attributes;
    }

    @Generated(from="TaskwarriorAuthentication", generator="Immutables")
    @Immutable
    private static final class ImmutableTaskwarriorAuthentication
    implements TaskwarriorAuthentication {
        private final UUID authKey;
        private final String organization;
        private final String user;

        private ImmutableTaskwarriorAuthentication() {
            this.authKey = null;
            this.organization = null;
            this.user = null;
        }

        private ImmutableTaskwarriorAuthentication(TaskwarriorAuthenticationBuilder builder) {
            this.authKey = builder.authKey;
            this.organization = builder.organization;
            this.user = builder.user;
        }

        @Override
        public UUID getAuthKey() {
            return this.authKey;
        }

        @Override
        public String getOrganization() {
            return this.organization;
        }

        @Override
        public String getUser() {
            return this.user;
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof ImmutableTaskwarriorAuthentication && this.equalTo((ImmutableTaskwarriorAuthentication)another);
        }

        private boolean equalTo(ImmutableTaskwarriorAuthentication another) {
            return this.authKey.equals(another.authKey) && this.organization.equals(another.organization) && this.user.equals(another.user);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.authKey.hashCode();
            h += (h << 5) + this.organization.hashCode();
            h += (h << 5) + this.user.hashCode();
            return h;
        }

        public String toString() {
            return "TaskwarriorAuthentication{authKey=" + this.authKey + ", organization=" + this.organization + ", user=" + this.user + "}";
        }
    }
}

