/*
 * Decompiled with CFR 0.152.
 */
package de.aaschmid.taskwarrior.message;

import de.aaschmid.taskwarrior.message.TaskwarriorMessage;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="TaskwarriorMessage", generator="Immutables")
@SuppressFBWarnings
@NotThreadSafe
final class TaskwarriorMessageBuilder {
    private Map<String, String> headers = new LinkedHashMap<String, String>();
    @Nullable
    private String payload;

    TaskwarriorMessageBuilder() {
    }

    public final TaskwarriorMessageBuilder from(TaskwarriorMessage instance) {
        Objects.requireNonNull(instance, "instance");
        this.putAllHeaders(instance.getHeaders());
        Optional<String> payloadOptional = instance.getPayload();
        if (payloadOptional.isPresent()) {
            this.payload(payloadOptional);
        }
        return this;
    }

    public final TaskwarriorMessageBuilder putHeader(String key, String value) {
        this.headers.put(Objects.requireNonNull(key, "headers key"), Objects.requireNonNull(value, "headers value"));
        return this;
    }

    public final TaskwarriorMessageBuilder putHeader(Map.Entry<String, ? extends String> entry) {
        String k = entry.getKey();
        String v = entry.getValue();
        this.headers.put(Objects.requireNonNull(k, "headers key"), Objects.requireNonNull(v, "headers value"));
        return this;
    }

    public final TaskwarriorMessageBuilder headers(Map<String, ? extends String> entries) {
        this.headers.clear();
        return this.putAllHeaders(entries);
    }

    public final TaskwarriorMessageBuilder putAllHeaders(Map<String, ? extends String> entries) {
        for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
            String k = e.getKey();
            String v = e.getValue();
            this.headers.put(Objects.requireNonNull(k, "headers key"), Objects.requireNonNull(v, "headers value"));
        }
        return this;
    }

    public final TaskwarriorMessageBuilder payload(String payload) {
        this.payload = Objects.requireNonNull(payload, "payload");
        return this;
    }

    public final TaskwarriorMessageBuilder payload(Optional<String> payload) {
        this.payload = payload.orElse(null);
        return this;
    }

    public TaskwarriorMessage build() {
        return new ImmutableTaskwarriorMessage(this);
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="TaskwarriorMessage", generator="Immutables")
    @Immutable
    private static final class ImmutableTaskwarriorMessage
    implements TaskwarriorMessage {
        private final Map<String, String> headers;
        @Nullable
        private final String payload;

        private ImmutableTaskwarriorMessage() {
            this.headers = null;
            this.payload = null;
        }

        private ImmutableTaskwarriorMessage(TaskwarriorMessageBuilder builder) {
            this.headers = TaskwarriorMessageBuilder.createUnmodifiableMap(false, false, builder.headers);
            this.payload = builder.payload;
        }

        @Override
        public Map<String, String> getHeaders() {
            return this.headers;
        }

        @Override
        public Optional<String> getPayload() {
            return Optional.ofNullable(this.payload);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof ImmutableTaskwarriorMessage && this.equalTo((ImmutableTaskwarriorMessage)another);
        }

        private boolean equalTo(ImmutableTaskwarriorMessage another) {
            return this.headers.equals(another.headers) && Objects.equals(this.payload, another.payload);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.headers.hashCode();
            h += (h << 5) + Objects.hashCode(this.payload);
            return h;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("TaskwarriorMessage{");
            builder.append("headers=").append(this.headers);
            if (this.payload != null) {
                builder.append(", ");
                builder.append("payload=").append(this.payload);
            }
            return builder.append("}").toString();
        }
    }
}

