/*
 * Decompiled with CFR 0.152.
 */
package de.aaschmid.taskwarrior.message;

import de.aaschmid.taskwarrior.message.ManifestHelper;
import de.aaschmid.taskwarrior.message.TaskwarriorAuthentication;
import de.aaschmid.taskwarrior.message.TaskwarriorRequestHeaderBuilder;
import de.aaschmid.taskwarrior.util.immutables.HiddenImplementationStyle;
import java.util.HashMap;
import java.util.Map;
import org.immutables.value.Value;

@Value.Immutable
@HiddenImplementationStyle
public interface TaskwarriorRequestHeader {
    public static final String HEADER_KEY_CLIENT = "client";
    public static final String HEADER_KEY_PROTOCOL = "protocol";
    public static final String HEADER_KEY_TYPE = "type";
    public static final String HEADER_AUTH_KEY_KEY = "key";
    public static final String HEADER_AUTH_KEY_ORG = "org";
    public static final String HEADER_AUTH_KEY_USER = "user";

    public static Builder taskwarriorRequestHeaderBuilder() {
        return new Builder();
    }

    public TaskwarriorAuthentication getAuthentication();

    public MessageType getType();

    @Value.Default
    default public String getClient() {
        return String.join((CharSequence)" ", ManifestHelper.getAttributeValuesFromManifest(this.getClass(), "Implementation-Title", "Implementation-Version"));
    }

    @Value.Default
    default public String getProtocol() {
        return "v1";
    }

    public Map<String, String> getAdditionalHeaderEntries();

    default public Map<String, String> toMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put(HEADER_KEY_TYPE, this.getType().headerValue);
        result.put(HEADER_KEY_PROTOCOL, this.getProtocol());
        result.put(HEADER_KEY_CLIENT, this.getClient());
        result.put(HEADER_AUTH_KEY_KEY, this.getAuthentication().getAuthKey().toString());
        result.put(HEADER_AUTH_KEY_ORG, this.getAuthentication().getOrganization());
        result.put(HEADER_AUTH_KEY_USER, this.getAuthentication().getUser());
        result.putAll(this.getAdditionalHeaderEntries());
        return result;
    }

    public static enum MessageType {
        STATISTICS("statistics"),
        SYNC("sync");

        public final String headerValue;

        private MessageType(String headerValue) {
            this.headerValue = headerValue;
        }
    }

    public static class Builder
    extends TaskwarriorRequestHeaderBuilder {
    }
}

