/*
 * Decompiled with CFR 0.152.
 */
package de.aaschmid.taskwarrior.message;

import de.aaschmid.taskwarrior.message.TaskwarriorAuthentication;
import de.aaschmid.taskwarrior.message.TaskwarriorRequestHeader;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="TaskwarriorRequestHeader", generator="Immutables")
@SuppressFBWarnings
@NotThreadSafe
class TaskwarriorRequestHeaderBuilder {
    private static final long INIT_BIT_AUTHENTICATION = 1L;
    private static final long INIT_BIT_TYPE = 2L;
    private long initBits = 3L;
    @Nullable
    private TaskwarriorAuthentication authentication;
    @Nullable
    private TaskwarriorRequestHeader.MessageType type;
    @Nullable
    private String client;
    @Nullable
    private String protocol;
    private Map<String, String> additionalHeaderEntries = new LinkedHashMap<String, String>();

    TaskwarriorRequestHeaderBuilder() {
        if (!(this instanceof TaskwarriorRequestHeader.Builder)) {
            throw new UnsupportedOperationException("Use: new TaskwarriorRequestHeader.Builder()");
        }
    }

    public final TaskwarriorRequestHeader.Builder from(TaskwarriorRequestHeader instance) {
        Objects.requireNonNull(instance, "instance");
        this.authentication(instance.getAuthentication());
        this.type(instance.getType());
        this.client(instance.getClient());
        this.protocol(instance.getProtocol());
        this.putAllAdditionalHeaderEntries(instance.getAdditionalHeaderEntries());
        return (TaskwarriorRequestHeader.Builder)this;
    }

    public final TaskwarriorRequestHeader.Builder authentication(TaskwarriorAuthentication authentication) {
        this.authentication = Objects.requireNonNull(authentication, "authentication");
        this.initBits &= 0xFFFFFFFFFFFFFFFEL;
        return (TaskwarriorRequestHeader.Builder)this;
    }

    public final TaskwarriorRequestHeader.Builder type(TaskwarriorRequestHeader.MessageType type) {
        this.type = Objects.requireNonNull(type, "type");
        this.initBits &= 0xFFFFFFFFFFFFFFFDL;
        return (TaskwarriorRequestHeader.Builder)this;
    }

    public final TaskwarriorRequestHeader.Builder client(String client) {
        this.client = Objects.requireNonNull(client, "client");
        return (TaskwarriorRequestHeader.Builder)this;
    }

    public final TaskwarriorRequestHeader.Builder protocol(String protocol) {
        this.protocol = Objects.requireNonNull(protocol, "protocol");
        return (TaskwarriorRequestHeader.Builder)this;
    }

    public final TaskwarriorRequestHeader.Builder putAdditionalHeaderEntry(String key, String value) {
        this.additionalHeaderEntries.put(Objects.requireNonNull(key, "additionalHeaderEntries key"), Objects.requireNonNull(value, "additionalHeaderEntries value"));
        return (TaskwarriorRequestHeader.Builder)this;
    }

    public final TaskwarriorRequestHeader.Builder putAdditionalHeaderEntry(Map.Entry<String, ? extends String> entry) {
        String k = entry.getKey();
        String v = entry.getValue();
        this.additionalHeaderEntries.put(Objects.requireNonNull(k, "additionalHeaderEntries key"), Objects.requireNonNull(v, "additionalHeaderEntries value"));
        return (TaskwarriorRequestHeader.Builder)this;
    }

    public final TaskwarriorRequestHeader.Builder additionalHeaderEntries(Map<String, ? extends String> entries) {
        this.additionalHeaderEntries.clear();
        return this.putAllAdditionalHeaderEntries(entries);
    }

    public final TaskwarriorRequestHeader.Builder putAllAdditionalHeaderEntries(Map<String, ? extends String> entries) {
        for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
            String k = e.getKey();
            String v = e.getValue();
            this.additionalHeaderEntries.put(Objects.requireNonNull(k, "additionalHeaderEntries key"), Objects.requireNonNull(v, "additionalHeaderEntries value"));
        }
        return (TaskwarriorRequestHeader.Builder)this;
    }

    public TaskwarriorRequestHeader build() {
        if (this.initBits != 0L) {
            throw new IllegalStateException(this.formatRequiredAttributesMessage());
        }
        return new ImmutableTaskwarriorRequestHeader(this);
    }

    private String formatRequiredAttributesMessage() {
        ArrayList<String> attributes = new ArrayList<String>();
        if ((this.initBits & 1L) != 0L) {
            attributes.add("authentication");
        }
        if ((this.initBits & 2L) != 0L) {
            attributes.add("type");
        }
        return "Cannot build TaskwarriorRequestHeader, some of required attributes are not set " + attributes;
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="TaskwarriorRequestHeader", generator="Immutables")
    @Immutable
    private static final class ImmutableTaskwarriorRequestHeader
    implements TaskwarriorRequestHeader {
        private final TaskwarriorAuthentication authentication;
        private final TaskwarriorRequestHeader.MessageType type;
        private final String client;
        private final String protocol;
        private final Map<String, String> additionalHeaderEntries;
        private static final byte STAGE_INITIALIZING = -1;
        private static final byte STAGE_UNINITIALIZED = 0;
        private static final byte STAGE_INITIALIZED = 1;
        private volatile transient InitShim initShim = new InitShim();

        private ImmutableTaskwarriorRequestHeader() {
            this.authentication = null;
            this.type = null;
            this.client = null;
            this.protocol = null;
            this.additionalHeaderEntries = null;
            this.initShim = null;
        }

        private ImmutableTaskwarriorRequestHeader(TaskwarriorRequestHeaderBuilder builder) {
            this.authentication = builder.authentication;
            this.type = builder.type;
            this.additionalHeaderEntries = TaskwarriorRequestHeaderBuilder.createUnmodifiableMap(false, false, builder.additionalHeaderEntries);
            if (builder.client != null) {
                this.initShim.client(builder.client);
            }
            if (builder.protocol != null) {
                this.initShim.protocol(builder.protocol);
            }
            this.client = this.initShim.getClient();
            this.protocol = this.initShim.getProtocol();
            this.initShim = null;
        }

        private String getClientInitialize() {
            return TaskwarriorRequestHeader.super.getClient();
        }

        private String getProtocolInitialize() {
            return TaskwarriorRequestHeader.super.getProtocol();
        }

        @Override
        public TaskwarriorAuthentication getAuthentication() {
            return this.authentication;
        }

        @Override
        public TaskwarriorRequestHeader.MessageType getType() {
            return this.type;
        }

        @Override
        public String getClient() {
            InitShim shim = this.initShim;
            return shim != null ? shim.getClient() : this.client;
        }

        @Override
        public String getProtocol() {
            InitShim shim = this.initShim;
            return shim != null ? shim.getProtocol() : this.protocol;
        }

        @Override
        public Map<String, String> getAdditionalHeaderEntries() {
            return this.additionalHeaderEntries;
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof ImmutableTaskwarriorRequestHeader && this.equalTo((ImmutableTaskwarriorRequestHeader)another);
        }

        private boolean equalTo(ImmutableTaskwarriorRequestHeader another) {
            return this.authentication.equals(another.authentication) && this.type.equals((Object)another.type) && this.client.equals(another.client) && this.protocol.equals(another.protocol) && this.additionalHeaderEntries.equals(another.additionalHeaderEntries);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.authentication.hashCode();
            h += (h << 5) + this.type.hashCode();
            h += (h << 5) + this.client.hashCode();
            h += (h << 5) + this.protocol.hashCode();
            h += (h << 5) + this.additionalHeaderEntries.hashCode();
            return h;
        }

        public String toString() {
            return "TaskwarriorRequestHeader{authentication=" + this.authentication + ", type=" + (Object)((Object)this.type) + ", client=" + this.client + ", protocol=" + this.protocol + ", additionalHeaderEntries=" + this.additionalHeaderEntries + "}";
        }

        @Generated(from="TaskwarriorRequestHeader", generator="Immutables")
        private final class InitShim {
            private byte clientBuildStage = 0;
            private String client;
            private byte protocolBuildStage = 0;
            private String protocol;

            private InitShim() {
            }

            String getClient() {
                if (this.clientBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.clientBuildStage == 0) {
                    this.clientBuildStage = (byte)-1;
                    this.client = Objects.requireNonNull(ImmutableTaskwarriorRequestHeader.this.getClientInitialize(), "client");
                    this.clientBuildStage = 1;
                }
                return this.client;
            }

            void client(String client) {
                this.client = client;
                this.clientBuildStage = 1;
            }

            String getProtocol() {
                if (this.protocolBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.protocolBuildStage == 0) {
                    this.protocolBuildStage = (byte)-1;
                    this.protocol = Objects.requireNonNull(ImmutableTaskwarriorRequestHeader.this.getProtocolInitialize(), "protocol");
                    this.protocolBuildStage = 1;
                }
                return this.protocol;
            }

            void protocol(String protocol) {
                this.protocol = protocol;
                this.protocolBuildStage = 1;
            }

            private String formatInitCycleMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if (this.clientBuildStage == -1) {
                    attributes.add("client");
                }
                if (this.protocolBuildStage == -1) {
                    attributes.add("protocol");
                }
                return "Cannot build TaskwarriorRequestHeader, attribute initializers form cycle " + attributes;
            }
        }
    }
}

