/*
 * Decompiled with CFR 0.152.
 */
package de.aaschmid.taskwarrior.thirdparty.org.bouncycastle.asn1;

import de.aaschmid.taskwarrior.thirdparty.org.bouncycastle.asn1.ASN1OctetString;
import de.aaschmid.taskwarrior.thirdparty.org.bouncycastle.asn1.ASN1OutputStream;
import de.aaschmid.taskwarrior.thirdparty.org.bouncycastle.asn1.ASN1Primitive;
import de.aaschmid.taskwarrior.thirdparty.org.bouncycastle.asn1.ASN1String;
import de.aaschmid.taskwarrior.thirdparty.org.bouncycastle.asn1.ASN1TaggedObject;
import de.aaschmid.taskwarrior.thirdparty.org.bouncycastle.asn1.StreamUtil;
import de.aaschmid.taskwarrior.thirdparty.org.bouncycastle.util.Arrays;
import de.aaschmid.taskwarrior.thirdparty.org.bouncycastle.util.Strings;
import java.io.IOException;

public class DERGeneralString
extends ASN1Primitive
implements ASN1String {
    private final byte[] string;

    public static DERGeneralString getInstance(Object object) {
        if (object == null || object instanceof DERGeneralString) {
            return (DERGeneralString)object;
        }
        if (object instanceof byte[]) {
            try {
                return (DERGeneralString)DERGeneralString.fromByteArray((byte[])object);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("encoding error in getInstance: " + exception.toString());
            }
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + object.getClass().getName());
    }

    public static DERGeneralString getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        ASN1Primitive aSN1Primitive = aSN1TaggedObject.getObject();
        if (bl || aSN1Primitive instanceof DERGeneralString) {
            return DERGeneralString.getInstance(aSN1Primitive);
        }
        return new DERGeneralString(ASN1OctetString.getInstance(aSN1Primitive).getOctets());
    }

    DERGeneralString(byte[] byArray) {
        this.string = byArray;
    }

    public DERGeneralString(String string) {
        this.string = Strings.toByteArray(string);
    }

    public String getString() {
        return Strings.fromByteArray(this.string);
    }

    public String toString() {
        return this.getString();
    }

    public byte[] getOctets() {
        return Arrays.clone(this.string);
    }

    boolean isConstructed() {
        return false;
    }

    int encodedLength() {
        return 1 + StreamUtil.calculateBodyLength(this.string.length) + this.string.length;
    }

    void encode(ASN1OutputStream aSN1OutputStream, boolean bl) throws IOException {
        aSN1OutputStream.writeEncoded(bl, 27, this.string);
    }

    public int hashCode() {
        return Arrays.hashCode(this.string);
    }

    boolean asn1Equals(ASN1Primitive aSN1Primitive) {
        if (!(aSN1Primitive instanceof DERGeneralString)) {
            return false;
        }
        DERGeneralString dERGeneralString = (DERGeneralString)aSN1Primitive;
        return Arrays.areEqual(this.string, dERGeneralString.string);
    }
}

