/*
 * Decompiled with CFR 0.152.
 */
package de.bytefish.fcmjava.client;

import de.bytefish.fcmjava.client.http.HttpClient;
import de.bytefish.fcmjava.client.http.IHttpClient;
import de.bytefish.fcmjava.client.settings.PropertiesBasedSettings;
import de.bytefish.fcmjava.http.client.IFcmClient;
import de.bytefish.fcmjava.http.options.IFcmClientSettings;
import de.bytefish.fcmjava.requests.data.DataMulticastMessage;
import de.bytefish.fcmjava.requests.data.DataUnicastMessage;
import de.bytefish.fcmjava.requests.groups.AddDeviceGroupMessage;
import de.bytefish.fcmjava.requests.groups.CreateDeviceGroupMessage;
import de.bytefish.fcmjava.requests.groups.RemoveDeviceGroupMessage;
import de.bytefish.fcmjava.requests.notification.NotificationMulticastMessage;
import de.bytefish.fcmjava.requests.notification.NotificationUnicastMessage;
import de.bytefish.fcmjava.requests.topic.TopicMulticastMessage;
import de.bytefish.fcmjava.requests.topic.TopicUnicastMessage;
import de.bytefish.fcmjava.responses.CreateDeviceGroupMessageResponse;
import de.bytefish.fcmjava.responses.FcmMessageResponse;
import de.bytefish.fcmjava.responses.TopicMessageResponse;

public class FcmClient
implements IFcmClient {
    private final IFcmClientSettings settings;
    private final IHttpClient httpClient;

    public FcmClient() {
        this(PropertiesBasedSettings.createFromDefault());
    }

    public FcmClient(IFcmClientSettings settings) {
        this(settings, new HttpClient(settings));
    }

    public FcmClient(IFcmClientSettings settings, IHttpClient httpClient) {
        if (settings == null) {
            throw new IllegalArgumentException("settings");
        }
        if (httpClient == null) {
            throw new IllegalArgumentException("httpClient");
        }
        this.settings = settings;
        this.httpClient = httpClient;
    }

    public FcmMessageResponse send(DataMulticastMessage message) {
        return this.post(message, FcmMessageResponse.class);
    }

    public FcmMessageResponse send(NotificationMulticastMessage notification) {
        return this.post(notification, FcmMessageResponse.class);
    }

    public FcmMessageResponse send(DataUnicastMessage message) {
        return this.post(message, FcmMessageResponse.class);
    }

    public FcmMessageResponse send(NotificationUnicastMessage notification) {
        return this.post(notification, FcmMessageResponse.class);
    }

    public CreateDeviceGroupMessageResponse send(CreateDeviceGroupMessage message) {
        return this.post(message, CreateDeviceGroupMessageResponse.class);
    }

    public TopicMessageResponse send(TopicUnicastMessage message) {
        return this.post(message, TopicMessageResponse.class);
    }

    public TopicMessageResponse send(TopicMulticastMessage message) {
        return this.post(message, TopicMessageResponse.class);
    }

    public void send(RemoveDeviceGroupMessage message) {
        this.post(message);
    }

    public void send(AddDeviceGroupMessage message) {
        this.post(message);
    }

    protected <TRequestMessage, TResponseMessage> TResponseMessage post(TRequestMessage requestMessage, Class<TResponseMessage> responseType) {
        return this.httpClient.post(requestMessage, responseType);
    }

    protected <TRequestMessage> void post(TRequestMessage requestMessage) {
        this.httpClient.post(requestMessage);
    }
}

