/*
 * Decompiled with CFR 0.152.
 */
package dev.amp.validator.visitor;

import dev.amp.validator.ValidatorProtos;
import dev.amp.validator.css.CssTokenUtil;
import dev.amp.validator.css.CssValidationException;
import dev.amp.validator.css.ErrorToken;
import dev.amp.validator.selector.AttrSelector;
import dev.amp.validator.selector.ClassSelector;
import dev.amp.validator.selector.Combinator;
import dev.amp.validator.selector.IdSelector;
import dev.amp.validator.selector.PseudoSelector;
import dev.amp.validator.selector.Selector;
import dev.amp.validator.selector.SimpleSelectorSequence;
import dev.amp.validator.selector.TypeSelector;
import dev.amp.validator.visitor.SelectorVisitor;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

public class SelectorSpecVisitor
extends SelectorVisitor {
    private final ValidatorProtos.SelectorSpec selectorSpec;
    private final List<ErrorToken> errorBuffer;

    public SelectorSpecVisitor(@Nonnull ValidatorProtos.SelectorSpec spec, @Nonnull List<ErrorToken> errorBuffer) {
        super(errorBuffer);
        this.selectorSpec = spec;
        this.errorBuffer = errorBuffer;
    }

    @Override
    public void visitTypeSelector(@Nonnull TypeSelector typeSelector) {
    }

    @Override
    public void visitIdSelector(@Nonnull IdSelector idSelector) {
    }

    @Override
    public void visitAttrSelector(@Nonnull AttrSelector attrSelector) throws CssValidationException {
        for (String allowedName : this.selectorSpec.getAttributeNameList()) {
            if (!allowedName.equals("*") && !allowedName.equals(attrSelector.getAttrName())) continue;
            return;
        }
        ArrayList<String> params = new ArrayList<String>();
        params.add("");
        params.add(attrSelector.getAttrName());
        ErrorToken errorToken = new ErrorToken(ValidatorProtos.ValidationError.Code.CSS_SYNTAX_DISALLOWED_ATTR_SELECTOR, params);
        CssTokenUtil.copyPosTo(attrSelector, errorToken);
        this.errorBuffer.add(errorToken);
    }

    @Override
    public void visitPseudoSelector(@Nonnull PseudoSelector pseudoSelector) throws CssValidationException {
        if (pseudoSelector.isClass()) {
            for (String allowedPseudoClass : this.selectorSpec.getPseudoClassList()) {
                if (!allowedPseudoClass.equals("*") && !allowedPseudoClass.equals(pseudoSelector.getName())) continue;
                return;
            }
            ArrayList<String> params = new ArrayList<String>();
            params.add("");
            params.add(pseudoSelector.getName());
            ErrorToken errorToken = new ErrorToken(ValidatorProtos.ValidationError.Code.CSS_SYNTAX_DISALLOWED_PSEUDO_CLASS, params);
            CssTokenUtil.copyPosTo(pseudoSelector, errorToken);
            this.errorBuffer.add(errorToken);
        } else {
            for (String allowedPseudoElement : this.selectorSpec.getPseudoElementList()) {
                if (!allowedPseudoElement.equals("*") && !allowedPseudoElement.equals(pseudoSelector.getName())) continue;
                return;
            }
            ArrayList params = new ArrayList();
            params.add("");
            params.add(pseudoSelector.getName());
            ErrorToken errorToken = new ErrorToken(ValidatorProtos.ValidationError.Code.CSS_SYNTAX_DISALLOWED_PSEUDO_ELEMENT, params);
            CssTokenUtil.copyPosTo(pseudoSelector, errorToken);
            this.errorBuffer.add(errorToken);
        }
    }

    @Override
    public void visitClassSelector(@Nonnull ClassSelector classSelector) {
    }

    @Override
    public void visitSimpleSelectorSequence(@Nonnull SimpleSelectorSequence sequence) {
    }

    @Override
    public void visitCombinator(@Nonnull Combinator combinator) {
    }

    @Override
    public void visitSelectorsGroup(@Nonnull Selector selector) {
    }
}

