/*
 * Decompiled with CFR 0.152.
 */
package dev.amp.validator;

import dev.amp.validator.ValidatorProtos;
import dev.amp.validator.utils.DispatchKeyUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

public class TagSpecDispatch {
    private Map<String, List<Integer>> tagSpecsByDispatch;
    private List<Integer> allTagSpecs = new ArrayList<Integer>();

    public void registerDispatchKey(@Nonnull String dispatchKey, int tagSpecId) {
        if (this.tagSpecsByDispatch == null) {
            this.tagSpecsByDispatch = new HashMap<String, List<Integer>>();
        }
        if (!this.tagSpecsByDispatch.containsKey(dispatchKey)) {
            ArrayList<Integer> tagSpecIds = new ArrayList<Integer>();
            tagSpecIds.add(tagSpecId);
            this.tagSpecsByDispatch.put(dispatchKey, tagSpecIds);
        } else {
            List<Integer> tagSpecIds = this.tagSpecsByDispatch.get(dispatchKey);
            tagSpecIds.add(tagSpecId);
        }
    }

    public List<Integer> matchingDispatchKey(@Nonnull String attrName, @Nonnull String attrValue, @Nonnull String mandatoryParent) {
        String noValueKey;
        List<Integer> noValueMatch;
        String noParentKey;
        List<Integer> noParentMatch;
        ArrayList<Integer> tagSpecIds = new ArrayList<Integer>();
        if (!this.hasDispatchKeys()) {
            return tagSpecIds;
        }
        String dispatchKey = DispatchKeyUtils.makeDispatchKey(ValidatorProtos.AttrSpec.DispatchKeyType.NAME_VALUE_PARENT_DISPATCH, attrName, attrValue, mandatoryParent);
        List<Integer> match = this.tagSpecsByDispatch.get(dispatchKey);
        if (match != null) {
            tagSpecIds.addAll(match);
        }
        if ((noParentMatch = this.tagSpecsByDispatch.get(noParentKey = DispatchKeyUtils.makeDispatchKey(ValidatorProtos.AttrSpec.DispatchKeyType.NAME_VALUE_DISPATCH, attrName, attrValue, ""))) != null) {
            tagSpecIds.addAll(noParentMatch);
        }
        if ((noValueMatch = this.tagSpecsByDispatch.get(noValueKey = DispatchKeyUtils.makeDispatchKey(ValidatorProtos.AttrSpec.DispatchKeyType.NAME_DISPATCH, attrName, "", ""))) != null) {
            tagSpecIds.addAll(noValueMatch);
        }
        if (attrName.equals(attrValue)) {
            tagSpecIds.addAll(this.matchingDispatchKey(attrName, "", mandatoryParent));
        }
        return tagSpecIds;
    }

    public void registerTagSpec(int tagSpecId) {
        this.allTagSpecs.add(tagSpecId);
    }

    public boolean empty() {
        return !this.hasDispatchKeys() && !this.hasTagSpecs();
    }

    public boolean hasDispatchKeys() {
        return this.tagSpecsByDispatch != null;
    }

    public boolean hasTagSpecs() {
        return this.allTagSpecs.size() > 0;
    }

    public List<Integer> allTagSpecs() {
        return this.allTagSpecs;
    }
}

