/*
 * Decompiled with CFR 0.152.
 */
package dev.dhruv.javaannotate.core.clazz;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import dev.dhruv.javaannotate.core.clazz.ClassCreator;
import javax.lang.model.element.Modifier;

public class BuilderCreator
extends ClassCreator {
    public static final String BUILDER = "Builder";

    public BuilderCreator(TypeSpec.Builder clazzBuilder) {
        super(clazzBuilder);
    }

    @Override
    public TypeSpec.Builder create() {
        TypeSpec.Builder typeSpec = TypeSpec.classBuilder((String)BUILDER).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC});
        MethodSpec constructor = MethodSpec.methodBuilder((String)BUILDER).returns((TypeName)ClassName.bestGuess((String)BUILDER)).addStatement("return new Builder()", new Object[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).build();
        MethodSpec buildMethod = MethodSpec.methodBuilder((String)"build").returns((TypeName)this.classObjectType).addStatement("return new " + this.clazz.name + "(this)", new Object[0]).addModifiers(new Modifier[]{Modifier.PUBLIC}).build();
        this.clazzBuilder.addMethod(constructor);
        typeSpec.addMethod(buildMethod);
        CodeBlock.Builder codeBlock = CodeBlock.builder();
        for (FieldSpec builderFieldSpec : this.clazz.fieldSpecs) {
            if (builderFieldSpec.modifiers.contains((Object)Modifier.FINAL) || builderFieldSpec.name.equalsIgnoreCase("sInstance")) continue;
            typeSpec.addField(builderFieldSpec);
            codeBlock.add("this." + builderFieldSpec.name + "=" + builderFieldSpec.name + ";\n", new Object[0]);
            MethodSpec builderAddFieldMethod = MethodSpec.methodBuilder((String)builderFieldSpec.name).returns((TypeName)ClassName.bestGuess((String)BUILDER)).addParameter(builderFieldSpec.type, builderFieldSpec.name, new Modifier[0]).addStatement("this." + builderFieldSpec.name + "=" + builderFieldSpec.name, new Object[0]).addStatement("return this", new Object[0]).build();
            typeSpec.addMethod(builderAddFieldMethod);
        }
        MethodSpec initBuilderMethod = MethodSpec.constructorBuilder().addParameter((TypeName)ClassName.bestGuess((String)BUILDER), BUILDER, new Modifier[0]).addCode(codeBlock.build()).build();
        this.clazzBuilder.addMethod(initBuilderMethod);
        this.clazzBuilder.addType(typeSpec.build());
        return this.clazzBuilder;
    }
}

