/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.fnjl.util;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

public class FNClockUtil {
    private static final Map<Runnable, Long> lastTimes = new HashMap<Runnable, Long>();

    public static void oneDayClockTimer(int hours, int minutes, Runnable runnable) {
        FNClockUtil.oneDayClockTimer(hours, minutes, runnable, false);
    }

    public static void oneDayClockTimer(final int hours, final int minutes, final Runnable runnable, boolean daemon) {
        Timer timer = new Timer(daemon);
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                Date date;
                long lastTime = 0L;
                if (lastTimes.containsKey(runnable)) {
                    lastTime = (Long)lastTimes.get(runnable);
                }
                if (System.currentTimeMillis() - lastTime > 3600000L && (date = new Date()).getHours() == hours && date.getMinutes() == minutes) {
                    runnable.run();
                    lastTimes.put(runnable, System.currentTimeMillis());
                }
            }
        };
        timer.schedule(task, 0L, 1000L);
    }
}

