/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.accounts.Account;
import android.content.Context;
import android.content.Intent;
import android.os.IBinder;
import android.os.Looper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.auth.api.signin.GoogleSignInAccount;
import com.google.android.gms.common.Feature;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.internal.ConnectionCallbacks;
import com.google.android.gms.common.api.internal.OnConnectionFailedListener;
import com.google.android.gms.common.api.zaa;
import com.google.android.gms.common.internal.BaseGmsClient;
import com.google.android.gms.common.internal.ClientSettings;
import com.google.android.gms.common.internal.IAccountAccessor;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public final class Api<O extends ApiOptions> {
    private final AbstractClientBuilder<?, O> zaa;
    private final ClientKey<?> zab;
    private final String zac;

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public <C extends Client> Api(@NonNull String name, @NonNull AbstractClientBuilder<C, O> clientBuilder, @NonNull ClientKey<C> clientKey) {
        void var1_1;
        void var3_3;
        void var2_2;
        Preconditions.checkNotNull(var2_2, "Cannot construct an Api with a null ClientBuilder");
        Preconditions.checkNotNull(var3_3, "Cannot construct an Api with a null ClientKey");
        this.zac = var1_1;
        this.zaa = var2_2;
        this.zab = var3_3;
    }

    @NonNull
    public final AbstractClientBuilder<?, O> zaa() {
        return this.zaa;
    }

    @NonNull
    public final AnyClientKey<?> zab() {
        return this.zab;
    }

    @NonNull
    public final BaseClientBuilder<?, O> zac() {
        return this.zaa;
    }

    @NonNull
    public final String zad() {
        return this.zac;
    }

    @KeepForSdk
    public static interface Client
    extends AnyClient {
        @KeepForSdk
        public int getMinApkVersion();

        @KeepForSdk
        @NonNull
        public Intent getSignInIntent();

        @Nullable
        @KeepForSdk
        public IBinder getServiceBrokerBinder();

        @KeepForSdk
        @NonNull
        public String getEndpointPackageName();

        @KeepForSdk
        @Nullable
        public String getLastDisconnectMessage();

        @KeepForSdk
        @NonNull
        public Set<Scope> getScopesForConnectionlessNonSignIn();

        @KeepForSdk
        public void connect(@NonNull BaseGmsClient.ConnectionProgressReportCallbacks var1);

        @KeepForSdk
        public void disconnect();

        @KeepForSdk
        public void disconnect(@NonNull String var1);

        @KeepForSdk
        public void dump(@NonNull String var1, @Nullable FileDescriptor var2, @NonNull PrintWriter var3, @Nullable String[] var4);

        @KeepForSdk
        public void getRemoteService(@Nullable IAccountAccessor var1, @Nullable Set<Scope> var2);

        @KeepForSdk
        public void onUserSignOut(@NonNull BaseGmsClient.SignOutCallbacks var1);

        @KeepForSdk
        public boolean isConnected();

        @KeepForSdk
        public boolean isConnecting();

        @KeepForSdk
        public boolean providesSignIn();

        @KeepForSdk
        public boolean requiresAccount();

        @KeepForSdk
        public boolean requiresGooglePlayServices();

        @KeepForSdk
        public boolean requiresSignIn();

        @KeepForSdk
        @NonNull
        public Feature[] getAvailableFeatures();

        @KeepForSdk
        @NonNull
        public Feature[] getRequiredFeatures();
    }

    @KeepForSdk
    public static interface AnyClient {
    }

    @VisibleForTesting
    @KeepForSdk
    public static final class ClientKey<C extends Client>
    extends AnyClientKey<C> {
    }

    @KeepForSdk
    public static class AnyClientKey<C extends AnyClient> {
    }

    public static interface ApiOptions {
        @NonNull
        public static final NoOptions NO_OPTIONS;

        static {
            NoOptions noOptions;
            NO_OPTIONS = noOptions = new NoOptions(null);
        }

        public static final class NoOptions
        implements NotRequiredOptions {
            private NoOptions() {
            }

            /* synthetic */ NoOptions(zaa zaa2) {
            }
        }

        public static interface HasGoogleSignInAccountOptions
        extends HasOptions {
            @Nullable
            public GoogleSignInAccount getGoogleSignInAccount();
        }

        public static interface HasAccountOptions
        extends HasOptions,
        NotRequiredOptions {
            @NonNull
            public Account getAccount();
        }

        public static interface Optional
        extends HasOptions,
        NotRequiredOptions {
        }

        public static interface HasOptions
        extends ApiOptions {
        }

        public static interface NotRequiredOptions
        extends ApiOptions {
        }
    }

    @VisibleForTesting
    @KeepForSdk
    public static abstract class AbstractClientBuilder<T extends Client, O>
    extends BaseClientBuilder<T, O> {
        /*
         * WARNING - void declaration
         */
        @Deprecated
        @KeepForSdk
        @NonNull
        public T buildClient(@NonNull Context context, @NonNull Looper looper, @NonNull ClientSettings commonSettings, @NonNull O apiOptions, @NonNull GoogleApiClient.ConnectionCallbacks connectedListener, @NonNull GoogleApiClient.OnConnectionFailedListener connectionFailedListener) {
            void var6_6;
            void var5_5;
            void var4_4;
            void var3_3;
            void var2_2;
            void var1_1;
            return this.buildClient((Context)var1_1, (Looper)var2_2, (ClientSettings)var3_3, var4_4, (ConnectionCallbacks)var5_5, (OnConnectionFailedListener)var6_6);
        }

        @KeepForSdk
        @NonNull
        public T buildClient(@NonNull Context context, @NonNull Looper looper, @NonNull ClientSettings clientSettings, @NonNull O o, @NonNull ConnectionCallbacks connectionCallbacks, @NonNull OnConnectionFailedListener onConnectionFailedListener) {
            Object object = new UnsupportedOperationException("buildClient must be implemented");
            throw object;
        }
    }

    @VisibleForTesting
    @KeepForSdk
    public static abstract class BaseClientBuilder<T extends AnyClient, O> {
        @KeepForSdk
        public static final int API_PRIORITY_GAMES = 1;
        @KeepForSdk
        public static final int API_PRIORITY_PLUS = 2;
        @KeepForSdk
        public static final int API_PRIORITY_OTHER = Integer.MAX_VALUE;

        @KeepForSdk
        public int getPriority() {
            return Integer.MAX_VALUE;
        }

        @KeepForSdk
        @NonNull
        public List<Scope> getImpliedScopes(@Nullable O o) {
            return Collections.emptyList();
        }
    }
}

